/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.logging;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPluginDialog
extends Dialog {
    static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z][0-9A-Za-z_]*");
    static final Pattern PATH_PATTERN = Pattern.compile("[^\"]*");
    private Set<String> namesTaken;
    private Text nameText;
    private Text pathText;
    private Label errorLabel;
    private String name;
    private String path;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewPluginDialog.this.validate();
        }
    };

    public NewPluginDialog(Shell parentShell, Set<String> namesTaken) {
        super(parentShell);
        this.setShellStyle(parentShell.getStyle() | 0x10 | 0x8000);
        this.namesTaken = namesTaken;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create new plugin configuration.");
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path.length() > 0 ? this.path : null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setText("The name of the plugin is not an identifier");
        this.errorLabel.setVisible(false);
        Composite nameContainer = new Composite(parent, 0);
        nameContainer.setLayout((Layout)new GridLayout(2, false));
        nameContainer.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (this.namesTaken.contains("new_plugin_" + i)) {
            ++i;
        }
        this.name = "new_plugin_" + i;
        Label label = new Label(nameContainer, 0);
        label.setText("The name of the new plugin: ");
        this.nameText = new Text(nameContainer, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.name);
        this.nameText.addModifyListener(this.modifyListener);
        this.path = "";
        Composite pathContainer = new Composite(parent, 0);
        pathContainer.setLayout((Layout)new GridLayout(2, false));
        pathContainer.setLayoutData((Object)new GridData(1808));
        label = new Label(pathContainer, 0);
        label.setText("The path of the new plugin: ");
        this.pathText = new Text(pathContainer, 2052);
        this.pathText.setLayoutData((Object)new GridData(768));
        this.pathText.setText(this.path);
        this.pathText.addModifyListener(this.modifyListener);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void validate() {
        String nameTemp = this.nameText.getText();
        if (this.namesTaken.contains(nameTemp)) {
            this.getButton(0).setEnabled(false);
            this.errorLabel.setText("A plugin with this name already exists.");
            this.errorLabel.setVisible(true);
            return;
        }
        if (!NAME_PATTERN.matcher(nameTemp).matches()) {
            this.getButton(0).setEnabled(false);
            this.errorLabel.setText("The name of the plugin must be a valid identifier.");
            this.errorLabel.setVisible(true);
            return;
        }
        String pathTemp = this.pathText.getText();
        if (!PATH_PATTERN.matcher(pathTemp).matches()) {
            this.getButton(0).setEnabled(false);
            this.errorLabel.setText("The path of the plugin is not valid.");
            this.errorLabel.setVisible(true);
            return;
        }
        this.getButton(0).setEnabled(true);
        this.errorLabel.setVisible(false);
        this.name = nameTemp;
        this.path = pathTemp;
    }
}

