/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcnppeditor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3FoldingSupport;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectConfigurationParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.progress.IProgressConstants;

public final class ReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final String OUTLINEUPDATE = "Outline update";
    private TTCNPPEditor editor;
    private IDocument document;
    private StringBuilder actualCode;

    public TTCNPPEditor getEditor() {
        return this.editor;
    }

    public void setEditor(TTCNPPEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
        this.actualCode = new StringBuilder(document.get());
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        int firstLine;
        if (this.editor == null || this.document == null) {
            return;
        }
        int lineBreaks = 0;
        try {
            if ("__insert".equals(dirtyRegion.getType())) {
                this.actualCode.insert(dirtyRegion.getOffset(), dirtyRegion.getText());
                lineBreaks = org.eclipse.titan.designer.editors.ttcn3editor.ReconcilingStrategy.calculateLineBreaks(dirtyRegion.getText(), this.document.getLegalLineDelimiters());
            } else {
                lineBreaks = org.eclipse.titan.designer.editors.ttcn3editor.ReconcilingStrategy.calculateLineBreaks(this.actualCode.substring(dirtyRegion.getOffset(), dirtyRegion.getOffset() + dirtyRegion.getLength()), this.document.getLegalLineDelimiters());
                this.actualCode.delete(dirtyRegion.getOffset(), dirtyRegion.getOffset() + dirtyRegion.getLength());
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            ErrorReporter.logError((String)("String length: " + this.actualCode.length() + " region type: " + dirtyRegion.getType() + " region offset: " + dirtyRegion.getOffset() + " region length: " + dirtyRegion.getLength() + " region text: '" + dirtyRegion.getText() + "'\n" + "Actual size of the document: " + this.document.get().length()));
            this.actualCode = new StringBuilder(this.document.get());
        }
        if (dirtyRegion.getOffset() == 0 && this.document.getLength() == dirtyRegion.getLength()) {
            if (!this.editor.isDirty()) {
                return;
            }
            IPreferencesService prefs = Platform.getPreferencesService();
            if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
                this.analyze(false);
            }
            return;
        }
        try {
            firstLine = this.document.getLineOfOffset(dirtyRegion.getOffset());
        }
        catch (BadLocationException e) {
            ErrorReporter.logWarningExceptionStackTrace((Exception)((Object)e));
            firstLine = 0;
        }
        IFile editedFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (editedFile == null) {
            return;
        }
        int length = dirtyRegion.getLength();
        TTCN3ReparseUpdater reparser = "__insert".equals(dirtyRegion.getType()) ? new TTCN3ReparseUpdater(editedFile, this.actualCode.toString(), firstLine + 1, lineBreaks, dirtyRegion.getOffset(), dirtyRegion.getOffset(), length) : new TTCN3ReparseUpdater(editedFile, this.actualCode.toString(), firstLine + 1, -1 * lineBreaks, dirtyRegion.getOffset(), dirtyRegion.getOffset() + length, -1 * length);
        IProject project = editedFile.getProject();
        if (project == null) {
            return;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(project);
        sourceParser.updateSyntax(editedFile, reparser);
        if (!this.editor.isSemanticCheckingDelayed()) {
            sourceParser.analyzeAll();
            WorkspaceJob op = new WorkspaceJob(OUTLINEUPDATE){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            List<Position> positions = new TTCN3FoldingSupport().calculatePositions(ReconcilingStrategy.this.document);
                            ReconcilingStrategy.this.editor.updateFoldingStructure(positions);
                            ReconcilingStrategy.this.editor.refreshOutlinePage();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(true);
            op.setUser(false);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.setRule((ISchedulingRule)project);
            op.schedule();
        } else {
            sourceParser.reportSyntacticOutdatingOnly(editedFile);
            sourceParser.analyzeAllOnlySyntactically();
        }
    }

    public void reconcile(IRegion partition) {
        this.fullReconciliation(false);
    }

    public void initialReconcile() {
        this.fullReconciliation(true);
    }

    private void fullReconciliation(boolean isInitial) {
        this.actualCode = new StringBuilder(this.document.get());
        GlobalIntervalHandler.putInterval(this.document, null);
        IPreferencesService prefs = Platform.getPreferencesService();
        if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            this.analyze(isInitial);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    List<Position> positions = new TTCN3FoldingSupport().calculatePositions(ReconcilingStrategy.this.document);
                    ReconcilingStrategy.this.editor.updateFoldingStructure(positions);
                    ReconcilingStrategy.this.editor.updateOutlinePage();
                }
            });
        }
    }

    public void analyze(boolean isInitial) {
        final IFile editedFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (editedFile == null || ResourceExclusionHelper.isExcluded((IResource)editedFile)) {
            return;
        }
        IProject project = editedFile.getProject();
        if (project == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                List<Position> positions = new TTCN3FoldingSupport().calculatePositions(ReconcilingStrategy.this.document);
                ReconcilingStrategy.this.getEditor().updateFoldingStructure(positions);
            }
        });
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(project);
        if (isInitial || !this.editor.isSemanticCheckingDelayed()) {
            projectSourceParser.reportOutdating(editedFile);
            projectSourceParser.analyzeAll();
            ProjectConfigurationParser projectConfigurationParser = GlobalParser.getConfigSourceParser(project);
            projectConfigurationParser.analyzeAll();
            WorkspaceJob op = new WorkspaceJob(OUTLINEUPDATE){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)editedFile)) {
                                ReconcilingStrategy.this.getEditor().updateOutlinePage();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(true);
            op.setUser(false);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.setRule((ISchedulingRule)project);
            op.schedule();
        } else {
            projectSourceParser.reportSyntacticOutdatingOnly(editedFile);
            projectSourceParser.analyzeAllOnlySyntactically();
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

