/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.parsers.ProjectConfigurationParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public final class GlobalParser {
    public static final String[] SUPPORTED_TTCN3_EXTENSIONS = new String[]{"ttcn3", "ttcn"};
    public static final String TTCNPP_EXTENSION = "ttcnpp";
    public static final String TTCNIN_EXTENSION = "ttcnin";
    public static final String[] SUPPORTED_ASN1_EXTENSIONS = new String[]{"asn1", "asn"};
    public static final String[] SUPPORTED_CONFIG_FILE_EXTENSIONS = new String[]{"cfg"};
    public static final String TRUE = "true";
    public static final String DOT = ".";
    private static final Map<IProject, ProjectSourceParser> TTCN3_PARSERS = new ConcurrentHashMap<IProject, ProjectSourceParser>();
    private static final Map<IProject, ProjectConfigurationParser> CFG_PARSERS = new ConcurrentHashMap<IProject, ProjectConfigurationParser>();

    private GlobalParser() {
    }

    public static boolean isSupportedTTCN3Extension(String extension) {
        for (int i = 0; i < SUPPORTED_TTCN3_EXTENSIONS.length; ++i) {
            if (!SUPPORTED_TTCN3_EXTENSIONS[i].equals(extension)) continue;
            return true;
        }
        return TTCNPP_EXTENSION.equals(extension);
    }

    public static boolean isSupportedExtension(String extension) {
        int i;
        for (i = 0; i < SUPPORTED_TTCN3_EXTENSIONS.length; ++i) {
            if (!SUPPORTED_TTCN3_EXTENSIONS[i].equals(extension)) continue;
            return true;
        }
        if (TTCNPP_EXTENSION.equals(extension) || TTCNIN_EXTENSION.equals(extension)) {
            return true;
        }
        for (i = 0; i < SUPPORTED_ASN1_EXTENSIONS.length; ++i) {
            if (!SUPPORTED_ASN1_EXTENSIONS[i].equals(extension)) continue;
            return true;
        }
        for (i = 0; i < SUPPORTED_CONFIG_FILE_EXTENSIONS.length; ++i) {
            if (!SUPPORTED_CONFIG_FILE_EXTENSIONS[i].equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static ProjectSourceParser getProjectSourceParser(IProject project) {
        ProjectSourceParser tempParser;
        if (TTCN3_PARSERS.containsKey(project)) {
            tempParser = TTCN3_PARSERS.get(project);
        } else {
            tempParser = new ProjectSourceParser(project);
            TTCN3_PARSERS.put(project, tempParser);
        }
        return tempParser;
    }

    public static ProjectConfigurationParser getConfigSourceParser(IProject project) {
        ProjectConfigurationParser tempParser;
        if (CFG_PARSERS.containsKey(project)) {
            tempParser = CFG_PARSERS.get(project);
        } else {
            tempParser = new ProjectConfigurationParser(project);
            CFG_PARSERS.put(project, tempParser);
        }
        return tempParser;
    }

    public static void clearAllInformation(IProject project) {
        if (TTCN3_PARSERS.containsKey(project)) {
            TTCN3_PARSERS.remove(project);
        }
        if (CFG_PARSERS.containsKey(project)) {
            CFG_PARSERS.remove(project);
        }
    }

    public static void clearAllInformation() {
        TTCN3_PARSERS.clear();
        CFG_PARSERS.clear();
    }

    public static void reAnalyzeSemantically() {
        WorkspaceJob job;
        for (ProjectSourceParser projectSourceParser : TTCN3_PARSERS.values()) {
            job = projectSourceParser.analyzeAll(false);
            if (job == null) continue;
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        for (ProjectConfigurationParser projectConfigurationParser : CFG_PARSERS.values()) {
            job = projectConfigurationParser.analyzeAll();
            if (job == null) continue;
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
    }

    public static void clearSemanticInformation() {
        for (ProjectSourceParser parser : TTCN3_PARSERS.values()) {
            parser.clearSemanticInformation();
        }
    }

    public static Set<IProject> getAllAnalyzedProjects() {
        return TTCN3_PARSERS.keySet();
    }
}

