/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.OutOfMemoryCheck;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.extensions.ExtensionHandler;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.ProjectSourceSemanticAnalyzer;
import org.eclipse.titan.designer.parsers.ProjectSourceSyntacticAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.properties.IPropertyChangeListener;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectConfigurationsPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.ui.progress.IProgressConstants;

public final class ProjectSourceParser {
    public static final String REQUIREDPROJECTNOTACCESSIBLE = "The project {0} is not accessible but is required to analyze the project {1}";
    public static final String REQUIREDPROJECTNOTTITANPROJECT = "The project {0} is not a TITAN project but is required to analyze the project {1}";
    private static final String SOURCE_ANALYSING = "Analysing the source code";
    private IProject project;
    private ProjectSourceSyntacticAnalyzer syntacticAnalyzer;
    private ProjectSourceSemanticAnalyzer semanticAnalyzer;
    private AtomicInteger fullAnalyzersRunning = new AtomicInteger();
    private volatile WorkspaceJob lastFullAnalyzes = null;
    private volatile boolean analyzesRunning = false;
    private AtomicInteger syntaxAnalyzersRunning = new AtomicInteger();
    private volatile WorkspaceJob lastSyntaxAnalyzes = null;
    private CompilationTimeStamp lastTimeChecked;
    private static IPropertyChangeListener listener = new IPropertyChangeListener(){

        @Override
        public void propertyChanged(IResource resource) {
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(resource.getProject());
            if (resource instanceof IFile) {
                projectSourceParser.reportOutdating((IFile)resource);
            } else if (resource instanceof IFolder) {
                projectSourceParser.reportOutdating((IFolder)resource);
            }
            projectSourceParser.analyzeAll();
        }
    };

    public ProjectSourceParser(IProject project) {
        this.project = project;
        this.syntacticAnalyzer = new ProjectSourceSyntacticAnalyzer(project, this);
        this.semanticAnalyzer = new ProjectSourceSemanticAnalyzer(this);
    }

    ProjectSourceSyntacticAnalyzer getSyntacticAnalyzer() {
        return this.syntacticAnalyzer;
    }

    public ProjectSourceSemanticAnalyzer getSemanticAnalyzer() {
        return this.semanticAnalyzer;
    }

    public CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    void setLastTimeChecked(CompilationTimeStamp lastTimeChecked) {
        this.lastTimeChecked = lastTimeChecked;
    }

    public boolean isOutdated(IFile file) {
        return this.syntacticAnalyzer.isOutdated(file) || this.semanticAnalyzer.isOutdated(file);
    }

    public Module getModuleByName(String name) {
        if (name == null) {
            return null;
        }
        return this.internalGetModuleByName(name, null, false);
    }

    public IFile getTTCN3IncludeFileByName(String name) {
        if (name == null) {
            return null;
        }
        return this.internalTTCN3IncludeFileByName(name, null);
    }

    private IFile internalTTCN3IncludeFileByName(String name, List<IProject> visitedprojects) {
        IFile tempFile = this.syntacticAnalyzer.internalGetTTCN3IncludeFileByName(name);
        if (tempFile != null) {
            return tempFile;
        }
        List<IProject> visited = visitedprojects;
        if (visited == null) {
            visited = new ArrayList<IProject>();
        }
        visited.add(this.project);
        for (IProject tempProject : ProjectBasedBuilder.getProjectBasedBuilder(this.project).getReferencedProjects()) {
            if (visited.contains(tempProject) || (tempFile = GlobalParser.getProjectSourceParser(tempProject).internalTTCN3IncludeFileByName(name, visited)) == null) continue;
            return tempFile;
        }
        return null;
    }

    public Collection<Module> getModules() {
        return this.semanticAnalyzer.internalGetModules();
    }

    private Module internalGetModuleByName(String name, List<IProject> visitedprojects, boolean uptodateOnly) {
        Module tempModule = this.semanticAnalyzer.internalGetModuleByName(name, uptodateOnly);
        if (tempModule != null) {
            return tempModule;
        }
        List<IProject> visited = visitedprojects;
        if (visited == null) {
            visited = new ArrayList<IProject>();
        }
        visited.add(this.project);
        for (IProject tempProject : ProjectBasedBuilder.getProjectBasedBuilder(this.project).getReferencedProjects()) {
            if (visited.contains(tempProject) || (tempModule = GlobalParser.getProjectSourceParser(tempProject).internalGetModuleByName(name, visited, uptodateOnly)) == null) continue;
            return tempModule;
        }
        return null;
    }

    public Set<String> getKnownModuleNames() {
        return this.internalGetKnownModuleNames(new ArrayList<IProject>());
    }

    private Set<String> internalGetKnownModuleNames(List<IProject> visitedprojects) {
        HashSet<String> temp = new HashSet<String>();
        if (visitedprojects.contains(this.project)) {
            return temp;
        }
        temp.addAll(this.semanticAnalyzer.internalGetKnownModuleNames());
        visitedprojects.add(this.project);
        for (IProject tempProject : ProjectBasedBuilder.getProjectBasedBuilder(this.project).getReferencedProjects()) {
            temp.addAll(GlobalParser.getProjectSourceParser(tempProject).internalGetKnownModuleNames(visitedprojects));
        }
        return temp;
    }

    public String containedModuleName(IFile file) {
        Module module = this.semanticAnalyzer.getModulebyFile(file);
        if (module != null) {
            return module.getName();
        }
        return null;
    }

    public Module containedModule(IFile file) {
        return this.semanticAnalyzer.getModulebyFile(file);
    }

    public WorkspaceJob reportOutdating(final IFile outdatedFile) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for: " + outdatedFile.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.syntacticAnalyzer.reportOutdating(outdatedFile);
                ProjectSourceParser.this.semanticAnalyzer.reportSemanticOutdating(outdatedFile);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)outdatedFile);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportSyntacticOutdatingOnly(final IFile outdatedFile) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for: " + outdatedFile.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.syntacticAnalyzer.reportSyntacticOutdatingOnly(outdatedFile);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)outdatedFile);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportOutdating(final List<IFile> outdatedFiles) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for " + outdatedFiles.size() + " files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                for (IFile file : outdatedFiles) {
                    ProjectSourceParser.this.syntacticAnalyzer.reportOutdating(file);
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule(this.getSchedulingRule());
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportSemanticOutdating(final List<IFile> outdatedFiles) {
        WorkspaceJob op = new WorkspaceJob("Reporting semantic outdate for " + outdatedFiles.size() + " files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                for (IFile outdatedFile : outdatedFiles) {
                    ProjectSourceParser.this.semanticAnalyzer.reportSemanticOutdating(outdatedFile);
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule(this.getSchedulingRule());
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob clearSemanticInformation() {
        WorkspaceJob op = new WorkspaceJob("Clearing all semantic information"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.semanticAnalyzer.clearSemanticInformation();
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule(this.getSchedulingRule());
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportOutdating(final IFolder outdatedFolder) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for: " + outdatedFolder.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.syntacticAnalyzer.reportOutdating(outdatedFolder);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)outdatedFolder);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob updateSyntax(final IFile file, final TTCN3ReparseUpdater reparser) {
        WorkspaceJob op = new WorkspaceJob("Updating the syntax incremantally for: " + file.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.syntacticAnalyzer.updateSyntax(file, reparser);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)file);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus internalDoAnalyzeWithReferences(SubMonitor monitor) {
        int i;
        Location location;
        if (!ProjectSourceParser.checkConfigurationRequirements(this.project, "org.eclipse.titan.designer.ontheflySemanticMarker")) {
            return Status.OK_STATUS;
        }
        if (OutOfMemoryCheck.isOutOfMemoryAlreadyReported()) {
            return Status.CANCEL_STATUS;
        }
        MarkerHandler.markAllMarkersForRemoval((IResource)this.project, "org.eclipse.titan.designer.ontheflySemanticMarker");
        MarkerHandler.markAllMarkersForRemoval((IResource)this.project, "org.eclipse.titan.designer.ontheflyMixedMarker");
        List<IProject> tobeAnalyzed = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getAllReachableProjects();
        LinkedList<IProject> temporalList = new LinkedList<IProject>();
        temporalList.addLast(this.project);
        tobeAnalyzed.remove(this.project);
        while (!temporalList.isEmpty()) {
            IProject[] tempProjects;
            IProject tempProject = (IProject)temporalList.getFirst();
            temporalList.removeFirst();
            if (tobeAnalyzed.contains(tempProject)) continue;
            tobeAnalyzed.add(tempProject);
            for (IProject iProject : tempProjects = ProjectBasedBuilder.getProjectBasedBuilder(tempProject).getReferencingProjects()) {
                if (GlobalParser.getProjectSourceParser((IProject)iProject).analyzesRunning) continue;
                if (iProject.isAccessible()) {
                    temporalList.addLast(iProject);
                    continue;
                }
                location = new Location((IResource)this.project);
                location.reportExternalProblem(MessageFormat.format("The project {0} is not accessible but requires to analyze the project {1}", iProject.getName(), tempProject.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
            }
        }
        ArrayList<IProject> additionalRequired = new ArrayList<IProject>();
        for (IProject project : tobeAnalyzed) {
            List<IProject> temp = ProjectBasedBuilder.getProjectBasedBuilder(project).getAllReachableProjects();
            for (IProject iProject : temp) {
                if (tobeAnalyzed.contains(iProject) || additionalRequired.contains(iProject) || GlobalParser.getProjectSourceParser(iProject).getLastTimeChecked() != null) continue;
                if (iProject.isAccessible()) {
                    additionalRequired.add(iProject);
                    continue;
                }
                location = new Location((IResource)project);
                location.reportExternalProblem(MessageFormat.format(REQUIREDPROJECTNOTACCESSIBLE, iProject.getName(), project.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
            }
        }
        tobeAnalyzed.addAll(additionalRequired);
        CompilationTimeStamp compilationCounter = CompilationTimeStamp.getNewCompilationCounter();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(tobeAnalyzed.size() * 2));
        progress.setTaskName("Analysis of projects");
        IPreferencesService preferenceService = Platform.getPreferencesService();
        boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (reportDebugInformation) {
            TITANDebugConsole.println("On-the-fly analyzation of project " + this.project.getName() + " started");
        }
        for (IProject project : tobeAnalyzed) {
            MarkerHandler.markAllMarkersForRemoval((IResource)project, "org.eclipse.titan.designer.ontheflySemanticMarker");
            MarkerHandler.markAllMarkersForRemoval((IResource)project, "org.eclipse.titan.designer.ontheflyMixedMarker");
        }
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        try {
            for (i = 0; i < tobeAnalyzed.size(); ++i) {
                progress.subTask("Analyzing project " + tobeAnalyzed.get(i).getName());
                GlobalParser.getProjectSourceParser((IProject)tobeAnalyzed.get((int)i)).analyzesRunning = true;
                if (tobeAnalyzed.get(i).isAccessible()) {
                    if (TITANNature.hasTITANNature(tobeAnalyzed.get(i))) {
                        GlobalParser.getProjectSourceParser((IProject)tobeAnalyzed.get((int)i)).syntacticAnalyzer.internalDoAnalyzeSyntactically((IProgressMonitor)progress.newChild(1));
                        arrayList.add(tobeAnalyzed.get(i));
                        continue;
                    }
                    Location location2 = new Location((IResource)this.project, 0, 0, 0);
                    location2.reportExternalProblem(MessageFormat.format(REQUIREDPROJECTNOTTITANPROJECT, tobeAnalyzed.get(i).getName(), this.project.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
                    progress.worked(1);
                    continue;
                }
                Location location2 = new Location((IResource)this.project);
                location2.reportExternalProblem(MessageFormat.format(REQUIREDPROJECTNOTACCESSIBLE, tobeAnalyzed.get(i).getName(), this.project.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
                progress.worked(1);
            }
            ProjectSourceSemanticAnalyzer.analyzeMultipleProjectsSemantically(arrayList, (IProgressMonitor)progress.newChild(tobeAnalyzed.size()), compilationCounter);
        }
        catch (Throwable throwable) {
            for (int i2 = 0; i2 < tobeAnalyzed.size(); ++i2) {
                GlobalParser.getProjectSourceParser((IProject)tobeAnalyzed.get((int)i2)).analyzesRunning = false;
            }
            throw throwable;
        }
        for (i = 0; i < tobeAnalyzed.size(); ++i) {
            GlobalParser.getProjectSourceParser((IProject)tobeAnalyzed.get((int)i)).analyzesRunning = false;
        }
        progress.done();
        this.lastTimeChecked = compilationCounter;
        return Status.OK_STATUS;
    }

    public WorkspaceJob analyzeAllOnlySyntactically() {
        IPreferencesService prefs = Platform.getPreferencesService();
        if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            return null;
        }
        WorkspaceJob op = new WorkspaceJob(SOURCE_ANALYSING){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                if (!ProjectSourceParser.this.project.isAccessible() || !TITANNature.hasTITANNature(ProjectSourceParser.this.project)) {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    return Status.CANCEL_STATUS;
                }
                if (!LicenseValidator.check()) {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    return Status.CANCEL_STATUS;
                }
                int priority = this.getThread().getPriority();
                try {
                    this.getThread().setPriority(1);
                    long absoluteStart = System.nanoTime();
                    IPreferencesService preferenceService = Platform.getPreferencesService();
                    String compilerOption = preferenceService.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.compilerMarkersAfterAnalyzation", "Become outdated", null);
                    if ("Are removed".equals(compilerOption)) {
                        ParserMarkerSupport.removeAllCompilerMarkers((IResource)ProjectSourceParser.this.project);
                    } else if ("Become outdated".equals(compilerOption)) {
                        for (IFile file : EditorTracker.keyset()) {
                            if (file.getProject() != ProjectSourceParser.this.project) continue;
                            ISemanticTITANEditor editor = EditorTracker.getEditor(file).get(0);
                            MarkerHandler.deprecateMarkers(editor, ParserMarkerSupport.getAllCompilerMarkers((IResource)ProjectSourceParser.this.project));
                        }
                    }
                    ProjectSourceParser.this.syntacticAnalyzer.internalDoAnalyzeSyntactically2(monitor);
                    boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The whole analysis block took " + (double)(System.nanoTime() - absoluteStart) * 1.0E-9 + " seconds to complete");
                    }
                }
                catch (Exception e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                finally {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    this.getThread().setPriority(priority);
                }
                return result;
            }
        };
        op.setPriority(30);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.setRule(this.getSchedulingRule());
        if (this.syntaxAnalyzersRunning.get() > 0 && this.lastSyntaxAnalyzes != null && this.lastSyntaxAnalyzes.getState() != 4) {
            this.lastSyntaxAnalyzes.cancel();
        }
        op.schedule();
        this.lastSyntaxAnalyzes = op;
        this.syntaxAnalyzersRunning.incrementAndGet();
        return op;
    }

    public WorkspaceJob analyzeAll() {
        return this.analyzeAll(true);
    }

    public WorkspaceJob analyzeAll(boolean allowQuickExit) {
        IPreferencesService prefs = Platform.getPreferencesService();
        if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            return null;
        }
        WorkspaceJob analyzes = new WorkspaceJob(SOURCE_ANALYSING){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                if (!ProjectSourceParser.this.project.isAccessible() || !TITANNature.hasTITANNature(ProjectSourceParser.this.project)) {
                    return Status.CANCEL_STATUS;
                }
                if (!LicenseValidator.check()) {
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int priority = this.getThread().getPriority();
                try {
                    this.getThread().setPriority(1);
                    long absoluteStart = System.nanoTime();
                    IPreferencesService preferenceService = Platform.getPreferencesService();
                    String compilerOption = preferenceService.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.compilerMarkersAfterAnalyzation", "Become outdated", null);
                    if ("Are removed".equals(compilerOption)) {
                        ParserMarkerSupport.removeAllCompilerMarkers((IResource)ProjectSourceParser.this.project);
                    } else if ("Become outdated".equals(compilerOption)) {
                        for (IFile file : EditorTracker.keyset()) {
                            if (file.getProject() != ProjectSourceParser.this.project) continue;
                            ISemanticTITANEditor editor = EditorTracker.getEditor(file).get(0);
                            MarkerHandler.deprecateMarkers(editor, ParserMarkerSupport.getAllCompilerMarkers((IResource)ProjectSourceParser.this.project));
                        }
                    }
                    result = ProjectSourceParser.this.internalDoAnalyzeWithReferences(SubMonitor.convert((IProgressMonitor)monitor));
                    boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The whole analysis block took " + (double)(System.nanoTime() - absoluteStart) * 1.0E-9 + " seconds to complete");
                    }
                }
                catch (Exception e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                finally {
                    this.getThread().setPriority(priority);
                }
                return result;
            }
        };
        analyzes.setPriority(30);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            analyzes.setSystem(false);
            analyzes.setUser(true);
        } else {
            analyzes.setSystem(true);
            analyzes.setUser(false);
        }
        analyzes.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        ISchedulingRule rule = this.getSchedulingRule();
        analyzes.setRule(rule);
        if (this.fullAnalyzersRunning.get() > 0) {
            if (this.lastFullAnalyzes != null && this.lastFullAnalyzes.getState() != 4) {
                this.lastFullAnalyzes.cancel();
            }
            this.lastFullAnalyzes = analyzes;
        }
        analyzes.schedule();
        this.fullAnalyzersRunning.incrementAndGet();
        final WorkspaceJob temp = analyzes;
        WorkspaceJob extensions = new WorkspaceJob("Executing Titan extensions"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                int priortity = this.getThread().getPriority();
                try {
                    this.getThread().setPriority(1);
                    progress.setTaskName("Executing Titan extensions");
                    progress.subTask("Waiting for semantic analysis");
                    try {
                        temp.join();
                    }
                    catch (Exception e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                    }
                    progress.subTask("Executing extensions");
                    if (Status.OK_STATUS.equals(temp.getResult())) {
                        ExtensionHandler.INSTANCE.executeContributors((IProgressMonitor)progress.newChild(100), ProjectSourceParser.this.project);
                    }
                }
                finally {
                    progress.done();
                    ProjectSourceParser.this.fullAnalyzersRunning.decrementAndGet();
                    this.getThread().setPriority(priortity);
                }
                return Status.OK_STATUS;
            }
        };
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            extensions.setSystem(false);
            extensions.setUser(true);
        } else {
            extensions.setSystem(true);
            extensions.setUser(false);
        }
        extensions.setRule(rule);
        extensions.schedule();
        return extensions;
    }

    private ISchedulingRule getSchedulingRule() {
        LinkedList<IProject> temporalList = new LinkedList<IProject>();
        List<IProject> projectTobeLocked = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getAllReachableProjects();
        IProject[] iterator = projectTobeLocked.iterator();
        while (iterator.hasNext()) {
            IProject temp = iterator.next();
            if (GlobalParser.getProjectSourceParser(temp).getLastTimeChecked() == null) continue;
            iterator.remove();
        }
        temporalList.addLast(this.project);
        projectTobeLocked.remove(this.project);
        while (!temporalList.isEmpty()) {
            IProject[] tempProjects;
            IProject tempProject = (IProject)temporalList.getFirst();
            temporalList.removeFirst();
            if (projectTobeLocked.contains(tempProject)) continue;
            projectTobeLocked.add(tempProject);
            for (IProject tempProject2 : tempProjects = ProjectBasedBuilder.getProjectBasedBuilder(tempProject).getReferencingProjects()) {
                if (GlobalParser.getProjectSourceParser((IProject)tempProject2).analyzesRunning) continue;
                temporalList.addLast(tempProject2);
            }
        }
        ArrayList<IProject> additionalRequired = new ArrayList<IProject>();
        for (IProject project : projectTobeLocked) {
            List<IProject> temp = ProjectBasedBuilder.getProjectBasedBuilder(project).getAllReachableProjects();
            for (IProject temp2 : temp) {
                if (projectTobeLocked.contains(temp2) || additionalRequired.contains(temp2)) continue;
                additionalRequired.add(temp2);
            }
        }
        projectTobeLocked.addAll(additionalRequired);
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule combinedRule = null;
        for (IProject project : projectTobeLocked) {
            combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)project), combinedRule);
        }
        return combinedRule;
    }

    public static boolean checkConfigurationRequirements(IProject project, String markerType) {
        IProject[] referencedProjects;
        try {
            referencedProjects = project.getReferencedProjects();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        List<ProjectConfigurationsPropertyData.ConfigurationRequirement> requirements = ProjectConfigurationsPropertyData.getConfigurationRequirements(project);
        int size = requirements.size();
        block2: for (int i = 0; i < size; ++i) {
            ProjectConfigurationsPropertyData.ConfigurationRequirement temp = requirements.get(i);
            if (temp.getConfiguration() == null || "".equals(temp.getConfiguration())) continue;
            for (IProject referencedProject : referencedProjects) {
                String name = referencedProject.getName();
                if (!name.equals(temp.getProjectName())) continue;
                String tempActiveConfiguration = ProjectFileHandler.getActiveConfigurationName(referencedProject);
                if (temp.getConfiguration().equals(tempActiveConfiguration)) continue block2;
                Location location = new Location((IResource)project);
                location.reportExternalProblem("In order to build project `" + project.getName() + "' project `" + name + "' must be using the `" + temp.getConfiguration() + "' configuration, but right now it is using `" + tempActiveConfiguration + "'", 2, markerType);
                return false;
            }
        }
        return true;
    }

    public void makefileCreatingAnalyzeAll() {
        this.fullAnalyzersRunning.incrementAndGet();
        ISchedulingRule rule = this.getSchedulingRule();
        Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
        try {
            this.internalDoAnalyzeWithReferences(null);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        finally {
            Job.getJobManager().endRule(rule);
            this.fullAnalyzersRunning.decrementAndGet();
        }
    }

    static {
        PropertyNotificationManager.addListener(listener);
    }
}

