/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.actions.IndentationSupport;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class IndentationPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences for automatic indentation";
    private static final String GROUP_LABEL = "General settings";
    private static final String TAB_POLICY_LABEL = "Indentation policy:";
    private static final String[][] TAB_POLICY_OPTIONS = new String[][]{{"Tab", "Tab"}, {"Spaces", "Spaces"}};
    private static final String INTENDATION_SIZE_LABEL = "Indentation size:";
    private Composite pageComposite;
    private Group generalGroup;
    private Composite indentationComposit;
    private ComboFieldEditor tabPolicy;
    private IntegerFieldEditor indentationSize;

    public IndentationPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.pageComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)gridData);
        this.generalGroup = new Group(this.pageComposite, 64);
        this.generalGroup.setText(GROUP_LABEL);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        this.generalGroup.setLayout((Layout)layout2);
        GridData gridData2 = new GridData(4, 4, true, false);
        this.generalGroup.setLayoutData((Object)gridData2);
        this.indentationComposit = new Composite((Composite)this.generalGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 3;
        this.indentationComposit.setLayoutData((Object)gridData);
        this.tabPolicy = new ComboFieldEditor("org.eclipse.titan.designer.indentation.indentationTabPolicy", TAB_POLICY_LABEL, TAB_POLICY_OPTIONS, this.indentationComposit);
        this.addField(this.tabPolicy);
        this.indentationSize = new IntegerFieldEditor("org.eclipse.titan.designer.indentation.indentationSize", INTENDATION_SIZE_LABEL, this.indentationComposit, 2);
        this.indentationSize.setValidRange(1, 32);
        this.addField((FieldEditor)this.indentationSize);
        this.initialize();
        return this.pageComposite;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("Spaces".equals(this.tabPolicy.getActualValue())) {
            this.indentationSize.setEnabled(true, this.indentationComposit);
        } else {
            this.indentationSize.setEnabled(false, this.indentationComposit);
        }
        super.propertyChange(event);
    }

    protected void createFieldEditors() {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        IndentationSupport.clearIndentString();
        boolean result = super.performOk();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.titan.designer");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return result;
    }

    public void dispose() {
        this.pageComposite.dispose();
        this.generalGroup.dispose();
        this.indentationComposit.dispose();
        this.tabPolicy.dispose();
        this.indentationSize.dispose();
        super.dispose();
    }
}

