/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class NamingConventionPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Naming convention related preferences of the on-the-fly checker.\nAll options use Java regular expressions.";
    private static final String REPORTNAMINGCONVENTIONPROBLEMS = "Report naming convention problems:";
    private static final String REPORTNAMINGCONVENTIONPROBLEMS_TOOLTIP = "When the name of a definition does not match the naming convention.";
    private static final String REPORT_MODULENAME_IN_DEFINITION = "Report if the name of the module is mentioned in the name of the definition";
    private static final String REPORT_MODULENAME_IN_DEFINITION_TOOLTIP = "Definitions can be referenced in the modulename.identifier format, in order to avoid a name collision.\nAdding the module name to the definition is unnecessary, this only makes it longer";
    private static final String REPORT_VISIBILITY_IN_DEFINITION = "Report visibility settings mentioned in the name of definitions";
    private static final String REPORT_VISIBILITY_IN_DEFINITION_TOOLTIP = "Visibility attributes should not be mentioned in the names of the definitions.\nThey should be explicitly set as visibility attributes of the definition";
    private boolean changed = false;
    private static final String[][] IGNORE_WARNING_ERROR = new String[][]{{"Ignore", "ignore"}, {"Warning", "warning"}, {"Error", "error"}};
    private Composite pagecomp;
    private boolean initilizing = true;

    protected void checkState() {
        if (!this.initilizing) {
            this.setErrorMessage(null);
        }
        super.checkState();
    }

    public NamingConventionPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    private StringFieldEditor createFieldEditor(Composite parent, String preference, String namepart) {
        RegexpFieldEditor stringEditor = new RegexpFieldEditor(preference, "Format of " + namepart + " names", parent, namepart);
        stringEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NamingConventionPreferencePage.this.changed = true;
            }
        });
        return stringEditor;
    }

    private ExpandableComposite createExtendableComposite(final Composite parent, String title) {
        ExpandableComposite ex = new ExpandableComposite(parent, 0, 50);
        ex.setText(title);
        ex.setExpanded(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        ex.setLayoutData((Object)data);
        ex.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Composite temp;
                for (temp = parent; temp != null && !(temp instanceof ScrolledComposite); temp = temp.getParent()) {
                }
                if (temp != null) {
                    Point point = NamingConventionPreferencePage.this.pagecomp.computeSize(-1, -1);
                    ((ScrolledComposite)temp).setMinSize(point);
                    ((ScrolledComposite)temp).layout(true, true);
                }
            }
        });
        return ex;
    }

    protected Control createContents(Composite parent) {
        this.pagecomp = new Composite(parent, 0);
        this.pagecomp.setLayout((Layout)new GridLayout(1, false));
        this.pagecomp.setLayoutData((Object)new GridData(1808));
        Control result = super.createContents(this.pagecomp);
        this.initilizing = false;
        return result;
    }

    protected void createFieldEditors() {
        Composite tempParent = this.getFieldEditorParent();
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportNamingConventionProblems", REPORTNAMINGCONVENTIONPROBLEMS, IGNORE_WARNING_ERROR, tempParent);
        Label text = comboedit.getLabelControl(tempParent);
        text.setToolTipText(REPORTNAMINGCONVENTIONPROBLEMS_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NamingConventionPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        this.createModuleSection(tempParent);
        this.createTTCN3GlobalSection(tempParent);
        this.createTTCN3LocalSection(tempParent);
        this.createTTCN3ComponentSection(tempParent);
        this.createOthersSection(tempParent);
    }

    private void createModuleSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "module names");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionTTCN3Module", "TTCN-3 module name"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionASN1Module", "ASN.1 module name"));
    }

    private void createTTCN3GlobalSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "global TTCN-3 definitions");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(true);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionAltstep", "altstep"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalConstant", "global constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionExternalConstant", "external constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionFunction", "function"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionExternalFunction", "external function"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionModuleParameter", "module parameter"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalPort", "global port"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalTemplate", "global template"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionTestcase", "testcase"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalTimer", "global timer"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionType", "type"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGroup", "group"));
    }

    private void createTTCN3LocalSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "local TTCN-3 definitions");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalConstant", "local constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalVariable", "local variable"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionlocalTemplate", "local template"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalVariableTemplate", "local variable template"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalTimer", "local timer"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionFormalParameter", "formal paremeter"));
    }

    private void createTTCN3ComponentSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "component internal TTCN-3 definitions");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionComponentConstant", "component constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionComponentVariable", "component variable"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionComponentTimer", "component timer"));
    }

    private void createOthersSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "other naming rules");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportModuleNameInDefinition", REPORT_MODULENAME_IN_DEFINITION, IGNORE_WARNING_ERROR, comp);
        Label text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_MODULENAME_IN_DEFINITION_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NamingConventionPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportVisibilityInDefinition", REPORT_VISIBILITY_IN_DEFINITION, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_VISIBILITY_IN_DEFINITION_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NamingConventionPreferencePage.this.changed = true;
            }
        });
        this.addField(comboedit);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.changed = true;
        super.propertyChange(event);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.changed && this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            this.changed = false;
            WorkspaceJob job = new WorkspaceJob("Re-analyzes"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    ErrorReporter.parallelWarningDisplayInMessageDialog((String)"Naming convention settings changed", (String)"Naming convention settings have changed, the known projects are re-analyzed completly.\nThis might take some time.");
                    NamingConventionHelper.clearCaches();
                    GlobalParser.clearSemanticInformation();
                    GlobalParser.reAnalyzeSemantically();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return result;
    }

    private static class RegexpFieldEditor
    extends StringFieldEditor {
        private final String regexpName;

        public RegexpFieldEditor(String name, String labelText, Composite parent, String regexpName) {
            super(name, labelText, UNLIMITED, parent);
            this.regexpName = regexpName;
        }

        public boolean isValid() {
            super.refreshValidState();
            return super.isValid();
        }

        protected boolean checkState() {
            String txt;
            boolean result = false;
            if (this.isEmptyStringAllowed()) {
                result = true;
            }
            if (this.getTextControl() == null) {
                result = false;
            }
            result = (txt = this.getTextControl().getText()).trim().length() > 0 || this.isEmptyStringAllowed();
            boolean bl = result = result && this.doCheckState();
            if (!result && this.getPage().getErrorMessage() == null) {
                this.showErrorMessage(this.getErrorMessage());
            }
            return result;
        }

        protected boolean doCheckState() {
            String newValue = this.getStringValue();
            try {
                Pattern.compile(newValue);
            }
            catch (PatternSyntaxException e) {
                this.setErrorMessage("The format of " + this.regexpName + " name regexp is wrong");
                return false;
            }
            return true;
        }
    }
}

