/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ListConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PlatformSpecificLibrariesOptionsData {
    public static final String SPECIFIC_LIBRARIES_PROPERTY = "SpecificLibrariesProperty";
    public static final String SPECIFIC_LIBRARIES_TAG = "SpecificLibraries";

    private PlatformSpecificLibrariesOptionsData() {
    }

    public static String[] getPlatformSpecificLibraries(IProject project, String platform) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", platform + SPECIFIC_LIBRARIES_PROPERTY));
            return ListConverter.convertToList(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting libraries of `" + project.getName() + "' for platform " + platform), (Throwable)e);
            return new String[0];
        }
    }

    public static void removeTITANAttributes(String platform, IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", platform + SPECIFIC_LIBRARIES_PROPERTY), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "' for platform " + platform), (Throwable)e);
        }
    }

    public static void loadMakefileSettings(String platform, Node root, IProject project) {
        NodeList resourceList = root.getChildNodes();
        String newValue = "";
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node resource = resourceList.item(i);
            String name = resource.getNodeName();
            if (!(platform + SPECIFIC_LIBRARIES_TAG).equals(name)) continue;
            NodeList subResources = resource.getChildNodes();
            ArrayList<String> values = new ArrayList<String>();
            for (int i2 = 0; i2 < subResources.getLength(); ++i2) {
                Node subResource = subResources.item(i2);
                if (!"listItem".equals(subResource.getNodeName())) continue;
                values.add(subResource.getTextContent());
            }
            newValue = ListConverter.convertFromList(values.toArray(new String[values.size()]));
        }
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", platform + SPECIFIC_LIBRARIES_PROPERTY);
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While loading settings of `" + project.getName() + "' for platform " + platform), (Throwable)e);
        }
    }

    public static void saveMakefileSettings(String platform, Element makefileSettings, Document document, IProject project) {
        try {
            Element list = document.createElement(platform + SPECIFIC_LIBRARIES_TAG);
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", platform + SPECIFIC_LIBRARIES_PROPERTY));
            String[] tempList = ListConverter.convertToList(temp);
            if (tempList.length > 0) {
                makefileSettings.appendChild(list);
                for (int j = 0; j < tempList.length; ++j) {
                    if (tempList[j] == null || tempList[j].length() <= 0) continue;
                    Element item = document.createElement("listItem");
                    item.appendChild(document.createTextNode(tempList[j]));
                    list.appendChild(item);
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving attributes of `" + project.getName() + "' for platform " + platform), (Throwable)e);
        }
    }

    public static void copyMakefileSettings(String platform, Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        NodeList resourceList = source.getChildNodes();
        String newValue = "";
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node resource = resourceList.item(i);
            String name = resource.getNodeName();
            if (!(platform + SPECIFIC_LIBRARIES_TAG).equals(name)) continue;
            NodeList subResources = resource.getChildNodes();
            ArrayList<String> values = new ArrayList<String>();
            for (int i2 = 0; i2 < subResources.getLength(); ++i2) {
                Node subResource = subResources.item(i2);
                if (!"listItem".equals(subResource.getNodeName())) continue;
                values.add(subResource.getTextContent());
            }
            newValue = ListConverter.convertFromList(values.toArray(new String[values.size()]));
        }
        if (!saveDefaultValues && "".equals(newValue)) {
            return;
        }
        Element list = document.createElement(platform + SPECIFIC_LIBRARIES_TAG);
        String[] tempList = ListConverter.convertToList(newValue);
        if (tempList.length > 0) {
            makefileSettings.appendChild(list);
            for (int j = 0; j < tempList.length; ++j) {
                if (!saveDefaultValues && (tempList[j] == null || tempList[j].length() <= 0)) continue;
                Element item = document.createElement("listItem");
                item.appendChild(document.createTextNode(tempList[j]));
                list.appendChild(item);
            }
        }
    }
}

