/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow.common;

import org.eclipse.efm.sew.launcher.workflow.common.TraceElementKind;
import org.eclipse.efm.sew.launcher.workflow.common.impl.TraceElementImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;

public class TraceElementCustomImpl
extends TraceElementImpl {
    public TraceElementCustomImpl(TraceElementKind nature, Object value) {
        this.nature = nature;
        this.value = value;
    }

    public static TraceElementCustomImpl create(String element) {
        return TraceElementCustomImpl.create(element, TraceElementKind.UNKNOWN);
    }

    public static TraceElementCustomImpl create(String element, TraceElementKind defaultNature) {
        TraceElementKind nature = TraceElementKind.UNKNOWN;
        String value = element;
        if (element.startsWith("//")) {
            nature = TraceElementKind.UNKNOWN;
            value = element.substring(2).trim();
        } else {
            int pos = element.indexOf(61);
            if (pos > 0) {
                String kind = element.substring(0, pos).trim();
                nature = TraceElementKind.get(kind);
                if (nature != null) {
                    value = element.substring(pos + 1).trim();
                } else {
                    nature = defaultNature;
                }
            } else {
                nature = defaultNature;
                value = element.trim();
            }
        }
        return new TraceElementCustomImpl(nature, value);
    }

    public void toWriter(PrettyPrintWriter writer) {
        Object value = this.getValue();
        if (this.getNature() == TraceElementKind.UNKNOWN) {
            writer.commentLine(value);
        } else {
            writer.appendTab(this.getNature().getLiteral()).append(" = ");
            if (value instanceof String) {
                String str = value.toString();
                if (!str.startsWith("\"") && !str.startsWith("'")) {
                    writer.append("\"").append(str).appendEol("\"");
                } else {
                    writer.appendEol(str);
                }
            } else if (value != null) {
                writer.appendEol(value.toString());
            } else {
                writer.appendEol("'<null>'");
            }
        }
    }
}

