/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow.serializer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.workflow.Director;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.serializer.impl.ModelGraphvizSerializerWorkerImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;

public class SymbexGraphvizSerializerWorkerCustomImpl
extends ModelGraphvizSerializerWorkerImpl
implements IWorkflowConfigurationConstants {
    public SymbexGraphvizSerializerWorkerCustomImpl(Director director, String name) {
        this.setDirector(director);
        this.setName(name);
    }

    public SymbexGraphvizSerializerWorkerCustomImpl(Director director, String name, String description) {
        this.setDirector(director);
        this.setName(name);
        this.setDescription(description);
    }

    public static SymbexGraphvizSerializerWorkerCustomImpl create(Director director, ILaunchConfiguration configuration) {
        String strFilename;
        String strTrace;
        String strFormat;
        SymbexGraphvizSerializerWorkerCustomImpl serializerWorker = new SymbexGraphvizSerializerWorkerCustomImpl(director, "symbex2graphiz");
        try {
            strFormat = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFormat = "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n";
        }
        if (strFormat != null && !strFormat.isEmpty()) {
            TraceSpecificationCustomImpl format = TraceSpecificationCustomImpl.create("format", strFormat);
            serializerWorker.setFormat(format);
        }
        try {
            strTrace = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strTrace = "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        if (strTrace != null && !strTrace.isEmpty()) {
            TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", strTrace);
            serializerWorker.setTrace(trace);
        }
        try {
            strFilename = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output.gv");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFilename = "symbex_output.gv";
        }
        serializerWorker.setFileName(strFilename);
        return serializerWorker;
    }

    public static SymbexGraphvizSerializerWorkerCustomImpl createSecond(Director director, ILaunchConfiguration configuration) {
        String strFilename;
        String strTrace;
        String strFormat;
        SymbexGraphvizSerializerWorkerCustomImpl serializerWorker = new SymbexGraphvizSerializerWorkerCustomImpl(director, "symbex2graphiz#extension");
        try {
            strFormat = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFormat = "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n";
        }
        if (strFormat != null && !strFormat.isEmpty()) {
            TraceSpecificationCustomImpl format = TraceSpecificationCustomImpl.create("format", strFormat);
            serializerWorker.setFormat(format);
        }
        try {
            strTrace = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strTrace = "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        if (strTrace != null && !strTrace.isEmpty()) {
            TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", strTrace);
            serializerWorker.setTrace(trace);
        }
        try {
            strFilename = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output_extension.gv");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFilename = "symbex_output_extension.gv";
        }
        serializerWorker.setFileName(strFilename);
        return serializerWorker;
    }

    public void toWriter(PrettyPrintWriter writer) {
        TraceSpecificationCustomImpl trace;
        writer.commentLine(this.getComment());
        writer.appendTab("serializer#symbex#graphviz");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        writer2.appendTabEol("property [");
        writer2.appendTab2Eol("info#selection = 'ALL'");
        writer2.appendTab2Eol("data#selection = 'MODIFIED'");
        writer2.appendTabEol("] // end property");
        TraceSpecificationCustomImpl format = (TraceSpecificationCustomImpl)this.getFormat();
        if (format != null) {
            format.toWriter(writer2);
        }
        if ((trace = (TraceSpecificationCustomImpl)this.getTrace()) != null) {
            trace.toWriter(writer2);
        }
        String justifier = "";
        writer2.appendTabEol("vfs [");
        String path = this.getFolderName();
        if (path != null) {
            writer2.appendTab2("folder = \"").append(path).appendEol("\"");
            justifier = "  ";
        }
        if ((path = this.getFileName()) != null) {
            writer2.appendTab2("file").append(justifier).append(" = \"").append(path).appendEol("\"");
        }
        writer2.appendTabEol("] // end vfs");
        writer.appendTabEol("}");
    }
}

