/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.claribole.zgrviewer.ConfigManager;

public class TextViewer
extends JFrame
implements ActionListener,
KeyListener,
Runnable {
    Thread runView;
    JButton okBt;
    JButton clearBt;
    StringBuffer text;
    int oldSize;
    int period;
    JTextArea ar;

    public TextViewer(StringBuffer msgs, String frameTitle, int d, boolean clear) {
        this.text = msgs;
        this.oldSize = this.text.length();
        this.period = d;
        this.ar = new JTextArea(this.text.toString());
        this.ar.setFont(ConfigManager.defaultFont);
        this.ar.setEditable(false);
        this.ar.setLineWrap(true);
        JScrollPane sp = new JScrollPane(this.ar);
        sp.setVerticalScrollBarPolicy(22);
        Container cpane = this.getContentPane();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 10;
        cpane.setLayout(gridBag);
        this.buildConstraints(constraints, 0, 0, 2, 1, 100, 98);
        gridBag.setConstraints(sp, constraints);
        cpane.add(sp);
        if (clear) {
            this.okBt = new JButton("OK");
            this.okBt.addActionListener(this);
            this.okBt.addKeyListener(this);
            constraints.anchor = 13;
            constraints.fill = 0;
            this.buildConstraints(constraints, 0, 1, 1, 1, 50, 2);
            gridBag.setConstraints(this.okBt, constraints);
            cpane.add(this.okBt);
            this.clearBt = new JButton("Clear");
            this.clearBt.addActionListener(this);
            this.clearBt.addKeyListener(this);
            constraints.anchor = 17;
            this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            gridBag.setConstraints(this.clearBt, constraints);
            cpane.add(this.clearBt);
        } else {
            this.okBt = new JButton("OK");
            this.okBt.addActionListener(this);
            this.okBt.addKeyListener(this);
            constraints.anchor = 10;
            constraints.fill = 2;
            this.buildConstraints(constraints, 0, 1, 2, 1, 100, 2);
            gridBag.setConstraints(this.okBt, constraints);
            cpane.add(this.okBt);
        }
        WindowAdapter w0 = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TextViewer.this.stop();
                TextViewer.this.dispose();
            }
        };
        this.addWindowListener(w0);
        this.setTitle(frameTitle);
        this.pack();
        this.setLocation(0, 0);
        this.setSize(700, 300);
        this.setVisible(true);
        this.okBt.requestFocus();
        if (this.period > 0) {
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if (TextViewer.this.isShowing()) {
                        TextViewer.this.start();
                    } else {
                        TextViewer.this.stop();
                    }
                }
            });
            this.start();
        }
    }

    public TextViewer(StringBuffer msgs, String frameTitle, int d, int x, int y, int width, int height, boolean clear) {
        this.text = msgs;
        this.oldSize = this.text.length();
        this.period = d;
        this.ar = new JTextArea(this.text.toString());
        this.ar.setFont(ConfigManager.defaultFont);
        this.ar.setEditable(false);
        this.ar.setLineWrap(true);
        this.ar.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(this.ar);
        sp.setVerticalScrollBarPolicy(22);
        Container cpane = this.getContentPane();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 10;
        cpane.setLayout(gridBag);
        this.buildConstraints(constraints, 0, 0, 2, 1, 100, 98);
        gridBag.setConstraints(sp, constraints);
        cpane.add(sp);
        if (clear) {
            this.okBt = new JButton("OK");
            this.okBt.addActionListener(this);
            this.okBt.addKeyListener(this);
            constraints.anchor = 13;
            constraints.fill = 0;
            this.buildConstraints(constraints, 0, 1, 1, 1, 50, 2);
            gridBag.setConstraints(this.okBt, constraints);
            cpane.add(this.okBt);
            this.clearBt = new JButton("Clear");
            this.clearBt.addActionListener(this);
            this.clearBt.addKeyListener(this);
            constraints.anchor = 17;
            this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            gridBag.setConstraints(this.clearBt, constraints);
            cpane.add(this.clearBt);
        } else {
            this.okBt = new JButton("OK");
            this.okBt.addActionListener(this);
            this.okBt.addKeyListener(this);
            constraints.anchor = 10;
            constraints.fill = 2;
            this.buildConstraints(constraints, 0, 1, 2, 1, 100, 2);
            gridBag.setConstraints(this.okBt, constraints);
            cpane.add(this.okBt);
        }
        WindowAdapter w0 = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TextViewer.this.stop();
                TextViewer.this.dispose();
            }
        };
        this.addWindowListener(w0);
        this.setTitle(frameTitle);
        this.pack();
        this.setLocation(x, y);
        this.setSize(width, height);
        this.setVisible(true);
        this.okBt.requestFocus();
        if (this.period > 0) {
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if (TextViewer.this.isShowing()) {
                        TextViewer.this.start();
                    } else {
                        TextViewer.this.stop();
                    }
                }
            });
            this.start();
        }
    }

    public void start() {
        this.runView = new Thread(this);
        this.runView.setPriority(1);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        while (this.runView == me) {
            if (this.text.length() != this.oldSize) {
                this.ar.setText(this.text.toString());
            }
            this.oldSize = this.text.length();
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBt) {
            this.stop();
            this.dispose();
        } else if (e.getSource() == this.clearBt) {
            this.text.setLength(0);
            this.ar.setText("");
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (e.getSource() == this.okBt) {
                this.stop();
                this.dispose();
            } else if (e.getSource() == this.clearBt) {
                this.text.setLength(0);
                this.ar.setText("");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

