/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.util.internal.EmfAdaptable;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
@EmfAdaptable
public class ChunkedResourceDescriptions
extends AbstractCompoundSelectable
implements IResourceDescriptions,
Externalizable {
    protected ConcurrentHashMap<String, ResourceDescriptionsData> chunk2resourceDescriptions = new ConcurrentHashMap();
    protected ResourceSet resourceSet;

    public ChunkedResourceDescriptions() {
    }

    public ChunkedResourceDescriptions(Map<String, ResourceDescriptionsData> initialData) {
        ConcurrentHashMap<String, ResourceDescriptionsData> _concurrentHashMap = new ConcurrentHashMap<String, ResourceDescriptionsData>(initialData);
        this.chunk2resourceDescriptions = _concurrentHashMap;
    }

    public ChunkedResourceDescriptions(Map<String, ResourceDescriptionsData> initialData, ResourceSet resourceSet) {
        this(initialData);
        this.setResourceSet(resourceSet);
    }

    public ChunkedResourceDescriptions createShallowCopyWith(ResourceSet resourceSet) {
        return new ChunkedResourceDescriptions(this.chunk2resourceDescriptions, resourceSet);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void setResourceSet(ResourceSet resourceSet) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)this.resourceSet, null);
        if (_notEquals) {
            Class<?> _class = this.getClass();
            String _name = _class.getName();
            String _plus = "This " + _name;
            String _plus_1 = String.valueOf(_plus) + " is already associated with a different resource set.";
            throw new IllegalStateException(_plus_1);
        }
        ChunkedResourceDescriptions index = ChunkedResourceDescriptions.findInEmfObject((Notifier)resourceSet);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)index, null);
        if (_notEquals_1) {
            Class<?> _class_1 = this.getClass();
            String _name_1 = _class_1.getName();
            String _plus_2 = "There is already a different " + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " installed in the given resource set.";
            throw new IllegalStateException(_plus_3);
        }
        this.resourceSet = resourceSet;
        this.attachToEmfObject((Notifier)resourceSet);
    }

    public ResourceDescriptionsData setContainer(String name, ResourceDescriptionsData descriptions) {
        return this.chunk2resourceDescriptions.put(name, descriptions);
    }

    public ResourceDescriptionsData removeContainer(String name) {
        return this.chunk2resourceDescriptions.remove(name);
    }

    @Override
    protected Iterable<? extends ISelectable> getSelectables() {
        return this.chunk2resourceDescriptions.values();
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        Collection<ResourceDescriptionsData> _values = this.chunk2resourceDescriptions.values();
        Functions.Function1<ResourceDescriptionsData, Iterable<IResourceDescription>> _function = new Functions.Function1<ResourceDescriptionsData, Iterable<IResourceDescription>>(){

            public Iterable<IResourceDescription> apply(ResourceDescriptionsData it) {
                return it.getAllResourceDescriptions();
            }
        };
        Iterable _map = IterableExtensions.map(_values, (Functions.Function1)_function);
        return Iterables.concat((Iterable)_map);
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        Collection<ResourceDescriptionsData> _values = this.chunk2resourceDescriptions.values();
        for (ResourceDescriptionsData selectable : _values) {
            boolean _notEquals;
            IResourceDescription result = selectable.getResourceDescription(uri);
            boolean bl = _notEquals = !Objects.equal((Object)result, null);
            if (!_notEquals) continue;
            return result;
        }
        return null;
    }

    public ResourceDescriptionsData getContainer(URI uri) {
        Collection<ResourceDescriptionsData> _values = this.chunk2resourceDescriptions.values();
        for (ResourceDescriptionsData container : _values) {
            boolean _notEquals;
            IResourceDescription result = container.getResourceDescription(uri);
            boolean bl = _notEquals = !Objects.equal((Object)result, null);
            if (!_notEquals) continue;
            return container;
        }
        return null;
    }

    public ResourceDescriptionsData getContainer(String containerHandle) {
        return this.chunk2resourceDescriptions.get(containerHandle);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numChunks = in.readInt();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numChunks, true);
        for (Integer i : _doubleDotLessThan) {
            String chunkName = in.readUTF();
            int numDescriptions = in.readInt();
            ArrayList<IResourceDescription> descriptions = new ArrayList<IResourceDescription>(numDescriptions);
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, numDescriptions, true);
            for (Integer j : _doubleDotLessThan_1) {
                Object _readObject = in.readObject();
                descriptions.add((IResourceDescription)_readObject);
            }
            ResourceDescriptionsData _resourceDescriptionsData = new ResourceDescriptionsData(descriptions);
            this.chunk2resourceDescriptions.put(chunkName, _resourceDescriptionsData);
        }
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        HashMap<String, ResourceDescriptionsData> copy = new HashMap<String, ResourceDescriptionsData>(this.chunk2resourceDescriptions);
        Set<Map.Entry<String, ResourceDescriptionsData>> _entrySet = copy.entrySet();
        int _size = _entrySet.size();
        out.writeInt(_size);
        Set<Map.Entry<String, ResourceDescriptionsData>> _entrySet_1 = copy.entrySet();
        Procedures.Procedure1<Map.Entry<String, ResourceDescriptionsData>> _function = new Procedures.Procedure1<Map.Entry<String, ResourceDescriptionsData>>(){

            public void apply(Map.Entry<String, ResourceDescriptionsData> it) {
                try {
                    String _key = it.getKey();
                    out.writeUTF(_key);
                    ResourceDescriptionsData _value = it.getValue();
                    Iterable<IResourceDescription> _allResourceDescriptions = _value.getAllResourceDescriptions();
                    Functions.Function1<IResourceDescription, Object> _function = new Functions.Function1<IResourceDescription, Object>(){

                        public Object apply(IResourceDescription it) {
                            IResourceDescription _xifexpression = null;
                            _xifexpression = it instanceof Serializable ? it : SerializableResourceDescription.createCopy(it);
                            return _xifexpression;
                        }
                    };
                    Iterable descriptions = IterableExtensions.map(_allResourceDescriptions, (Functions.Function1)_function);
                    int _size = IterableExtensions.size((Iterable)descriptions);
                    out.writeInt(_size);
                    Procedures.Procedure1<Object> _function_1 = new Procedures.Procedure1<Object>(){

                        public void apply(Object it) {
                            try {
                                out.writeObject(it);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    IterableExtensions.forEach((Iterable)descriptions, (Procedures.Procedure1)_function_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        IterableExtensions.forEach(_entrySet_1, (Procedures.Procedure1)_function);
    }

    public static ChunkedResourceDescriptions findInEmfObject(Notifier emfObject) {
        for (Adapter adapter : emfObject.eAdapters()) {
            if (!(adapter instanceof ChunkedResourceDescriptionsAdapter)) continue;
            return ((ChunkedResourceDescriptionsAdapter)adapter).get();
        }
        return null;
    }

    public static ChunkedResourceDescriptions removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        int i = 0;
        int max = adapters.size();
        while (i < max) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter instanceof ChunkedResourceDescriptionsAdapter) {
                emfObject.eAdapters().remove(i);
                return ((ChunkedResourceDescriptionsAdapter)adapter).get();
            }
            ++i;
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        ChunkedResourceDescriptions result = ChunkedResourceDescriptions.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for ChunkedResourceDescriptions");
        }
        ChunkedResourceDescriptionsAdapter adapter = new ChunkedResourceDescriptionsAdapter(this);
        emfObject.eAdapters().add((Object)adapter);
    }

    public static class ChunkedResourceDescriptionsAdapter
    extends AdapterImpl {
        private ChunkedResourceDescriptions element;

        public ChunkedResourceDescriptionsAdapter(ChunkedResourceDescriptions element) {
            this.element = element;
        }

        public ChunkedResourceDescriptions get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == ChunkedResourceDescriptions.class;
        }
    }
}

