/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveInstanceKind implements Enumerator
{
    BUFFER(0, "buffer", "buffer"),
    MESSAGE(1, "message", "message"),
    PORT(2, "port", "port"),
    SIGNAL(3, "signal", "signal"),
    COM_POINT(4, "com_point", "com_point"),
    CHANNEL(5, "channel", "channel"),
    MACHINE(6, "machine", "machine"),
    VERTEX(7, "vertex", "vertex");

    public static final int BUFFER_VALUE = 0;
    public static final int MESSAGE_VALUE = 1;
    public static final int PORT_VALUE = 2;
    public static final int SIGNAL_VALUE = 3;
    public static final int COM_POINT_VALUE = 4;
    public static final int CHANNEL_VALUE = 5;
    public static final int MACHINE_VALUE = 6;
    public static final int VERTEX_VALUE = 7;
    private static final PrimitiveInstanceKind[] VALUES_ARRAY;
    public static final List<PrimitiveInstanceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveInstanceKind[]{BUFFER, MESSAGE, PORT, SIGNAL, COM_POINT, CHANNEL, MACHINE, VERTEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveInstanceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveInstanceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveInstanceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveInstanceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveInstanceKind get(int value) {
        switch (value) {
            case 0: {
                return BUFFER;
            }
            case 1: {
                return MESSAGE;
            }
            case 2: {
                return PORT;
            }
            case 3: {
                return SIGNAL;
            }
            case 4: {
                return COM_POINT;
            }
            case 5: {
                return CHANNEL;
            }
            case 6: {
                return MACHINE;
            }
            case 7: {
                return VERTEX;
            }
        }
        return null;
    }

    private PrimitiveInstanceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

