/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValueElementSpecificationKind implements Enumerator
{
    FIELD(0, "field", "field"),
    INDEX(1, "index", "index"),
    PARAMETER(2, "parameter", "parameter");

    public static final int FIELD_VALUE = 0;
    public static final int INDEX_VALUE = 1;
    public static final int PARAMETER_VALUE = 2;
    private static final ValueElementSpecificationKind[] VALUES_ARRAY;
    public static final List<ValueElementSpecificationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValueElementSpecificationKind[]{FIELD, INDEX, PARAMETER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValueElementSpecificationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueElementSpecificationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueElementSpecificationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueElementSpecificationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueElementSpecificationKind get(int value) {
        switch (value) {
            case 0: {
                return FIELD;
            }
            case 1: {
                return INDEX;
            }
            case 2: {
                return PARAMETER;
            }
        }
        return null;
    }

    private ValueElementSpecificationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

