/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.glyphs.VRectangle;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class FRectangle<T>
extends VRectangle {
    float MASK_ALPHA_TOP = 0.0f;
    float MASK_ALPHA_BOTTOM = 1.0f;
    BufferedImage image;
    AffineTransform at;

    public FRectangle() {
        this(0.0, 0.0, 0, 10.0, 10.0, Color.WHITE, Color.BLACK, 0.0f, 1.0f);
    }

    public FRectangle(double x, double y, int z, double w, double h, Color c, float ta, float ba) {
        this(x, y, z, w, h, c, Color.BLACK, ta, ba);
    }

    public FRectangle(double x, double y, int z, double w, double h, Color c, Color bc, float ta, float ba) {
        super(x, y, z, w, h, c, bc);
        this.MASK_ALPHA_TOP = ta;
        this.MASK_ALPHA_BOTTOM = ba;
        this.createMask();
    }

    public void setGradientTopAlpha(float a) {
        this.MASK_ALPHA_TOP = a;
        if (this.image != null) {
            this.image.flush();
        }
        this.createMask();
    }

    public void setGradientBottomAlpha(float a) {
        this.MASK_ALPHA_BOTTOM = a;
        if (this.image != null) {
            this.image.flush();
        }
        this.createMask();
    }

    void createMask() {
        GradientPaint mask = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, this.MASK_ALPHA_TOP), 0.0f, (float)this.vh, new Color(1.0f, 1.0f, 1.0f, this.MASK_ALPHA_BOTTOM));
        this.image = new BufferedImage((int)this.vw, (int)this.vh, 2);
        Graphics2D g2 = this.image.createGraphics();
        g2.setColor(this.color);
        g2.fillRect(0, 0, (int)this.vw, (int)this.vh);
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, (int)this.vw, (int)this.vh);
        g2.dispose();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            if (this.isFilled()) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                g.setTransform(this.at);
                g.drawImage(this.image, AffineTransform.getScaleInstance(this.coef, this.coef), null);
                g.setTransform(stdT);
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].cx - this.pc[i].cw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].cx - this.pc[i].cw + 2 * this.pc[i].cw - 1 < vW || dy + this.pc[i].cy - this.pc[i].ch + 2 * this.pc[i].ch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcw > 1 && this.pc[i].lch > 1) {
            if (this.isFilled()) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                g.setTransform(this.at);
                g.drawImage(this.image, AffineTransform.getScaleInstance(this.coef, this.coef), null);
                g.setTransform(stdT);
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].lcx - this.pc[i].lcw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].lcx - this.pc[i].lcw + 2 * this.pc[i].lcw - 1 < vW || dy + this.pc[i].lcy - this.pc[i].lch + 2 * this.pc[i].lch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Object clone() {
        FRectangle<T> res = new FRectangle<T>(this.vx, this.vy, this.vz, this.vw, this.vh, this.color, this.borderColor, this.MASK_ALPHA_TOP, this.MASK_ALPHA_BOTTOM);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

