/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VRectangle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class PRectangle<T>
extends VRectangle {
    Paint gp;
    Paint highlightPaint = null;
    volatile boolean highlighted = false;
    AffineTransform at;

    public PRectangle(Paint gp) {
        this(0.0, 0.0, 0, 10.0, 10.0, gp);
    }

    public PRectangle(double x, double y, int z, double w, double h, Paint p) {
        this(x, y, z, w, h, p, Color.BLACK);
    }

    public PRectangle(double x, double y, int z, double w, double h, Paint p, Color bc) {
        super(x, y, z, w, h, Color.WHITE, bc);
        this.gp = p;
    }

    public void setPaint(Paint p) {
        this.gp = p;
    }

    public Paint getPaint() {
        return this.gp;
    }

    public void setCursorInsidePaint(Paint p) {
        this.highlightPaint = p;
    }

    @Override
    public void highlight(boolean h, Color unused) {
        this.highlighted = h;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
            this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
            g.setTransform(this.at);
            if (this.isFilled()) {
                g.setPaint(this.highlighted && this.highlightPaint != null ? this.highlightPaint : this.gp);
                g.fillRect(0, 0, (int)Math.round(this.vw), (int)Math.round(this.vh));
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].cx - this.pc[i].cw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].cx - this.pc[i].cw + 2 * this.pc[i].cw - 1 < vW || dy + this.pc[i].cy - this.pc[i].ch + 2 * this.pc[i].ch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(0, 0, (int)Math.round(this.vw), (int)Math.round(this.vh));
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(0, 0, (int)Math.round(this.vw), (int)Math.round(this.vh));
                }
            }
            g.setTransform(stdT);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcw > 1 && this.pc[i].lch > 1) {
            this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
            this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
            g.setTransform(this.at);
            if (this.isFilled()) {
                g.setPaint(this.highlighted && this.highlightPaint != null ? this.highlightPaint : this.gp);
                g.fillRect(0, 0, (int)Math.round(this.vw), (int)Math.round(this.vh));
            }
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].lcx - this.pc[i].lcw > 0 || dy + this.pc[i].lcy - this.pc[i].lch > 0 || dx + this.pc[i].lcx - this.pc[i].lcw + 2 * this.pc[i].lcw - 1 < vW || dy + this.pc[i].lcy - this.pc[i].lch + 2 * this.pc[i].lch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(0, 0, (int)Math.round(this.vw), (int)Math.round(this.vh));
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(0, 0, (int)Math.round(this.vw), (int)Math.round(this.vh));
                }
            }
            g.setTransform(stdT);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Object clone() {
        PRectangle<T> res = new PRectangle<T>(this.vx, this.vy, 0, this.vw, this.vh, this.gp, this.getBorderColor());
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

