/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddArchiveToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public AddArchiveToBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public AddArchiveToBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private AddArchiveToBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 14);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_label);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_tooltip);
    }

    @Override
    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath_archives;
    }

    public void run() {
        Shell shell = this.getShell();
        final IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries(shell);
        if (selected == null) {
            return;
        }
        try {
            final IJavaProject javaProject = (IJavaProject)this.getSelectedElements().get(0);
            IStatus status = ClasspathModifier.checkAddExternalJarsPrecondition(selected, CPJavaProject.createFromExisting(javaProject));
            if (status.getSeverity() == 4) {
                MessageDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.AddArchiveToBuildpathAction_InfoTitle, (String)status.getMessage());
                return;
            }
            if (status.getSeverity() == 1) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)NewWizardMessages.AddArchiveToBuildpathAction_InfoTitle, (String)status.getMessage());
            } else if (status.getSeverity() == 2) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)NewWizardMessages.AddArchiveToBuildpathAction_InfoTitle, (String)status.getMessage());
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = AddArchiveToBuildpathAction.this.addExternalJars(selected, javaProject, monitor);
                        if (result.size() > 0) {
                            AddArchiveToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.AddArchiveToBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            this.showExceptionDialog(e, NewWizardMessages.AddArchiveToBuildpathAction_ErrorTitle);
            JavaPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private List<IJavaElement> addExternalJars(IPath[] jarPaths, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            CPJavaProject cpProject = CPJavaProject.createFromExisting(project);
            BuildpathDelta delta = ClasspathModifier.addExternalJars(jarPaths, cpProject);
            ClasspathModifier.commitClassPath(cpProject, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            this.informListeners(delta);
            List<CPListElement> addedEntries = delta.getAddedEntries();
            ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(addedEntries.size());
            int i = 0;
            while (i < addedEntries.size()) {
                IClasspathEntry entry = addedEntries.get(i).getClasspathEntry();
                IPackageFragmentRoot elem = project.findPackageFragmentRoot(entry.getPath());
                if (elem != null) {
                    result.add((IJavaElement)elem);
                }
                ++i;
            }
            monitor.worked(1);
            ArrayList<IJavaElement> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected boolean canHandle(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object first = selection.getFirstElement();
        return first instanceof IJavaProject;
    }
}

