/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class WorkingSets {
    public static String[] getWorkingSets() {
        ArrayList<String> workingSets = new ArrayList<String>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (workingSet.isVisible()) {
                workingSets.add(workingSet.getName());
            }
            ++n2;
        }
        return workingSets.toArray(new String[workingSets.size()]);
    }

    public static IWorkingSet getOrCreateWorkingSet(String workingSetName) {
        IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = wsm.getWorkingSet(workingSetName);
        if (workingSet == null) {
            workingSet = wsm.createWorkingSet(workingSetName, new IAdaptable[0]);
            workingSet.setId("org.eclipse.ui.resourceWorkingSetPage");
            wsm.addWorkingSet(workingSet);
        }
        return workingSet;
    }

    public static void addToWorkingSet(IProject[] projects, String workingSetName) {
        IWorkingSet[] workingSets = new IWorkingSet[]{WorkingSets.getOrCreateWorkingSet(workingSetName)};
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            manager.addToWorkingSets((IAdaptable)project, workingSets);
            ++n2;
        }
    }

    public static void addToWorkingSets(IProject[] projects, List<IWorkingSet> workingSets) {
        if (projects != null && projects.length > 0 && workingSets != null && !workingSets.isEmpty()) {
            for (IWorkingSet workingSet : workingSets) {
                if (workingSet == null) continue;
                IAdaptable[] adaptedProjects = workingSet.adaptElements((IAdaptable[])projects);
                IAdaptable[] oldElements = workingSet.getElements();
                IAdaptable[] newElements = new IAdaptable[oldElements.length + adaptedProjects.length];
                System.arraycopy(oldElements, 0, newElements, 0, oldElements.length);
                System.arraycopy(adaptedProjects, 0, newElements, oldElements.length, adaptedProjects.length);
                workingSet.setElements(newElements);
            }
        }
    }

    public static void addToWorkingSets(Collection<IProject> projects, List<IWorkingSet> workingSets) {
        WorkingSets.addToWorkingSets(projects.toArray(new IProject[projects.size()]), workingSets);
    }

    public static Set<IProject> getProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = manager.getAllWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            try {
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    IProject project = (IProject)element.getAdapter(IProject.class);
                    if (project != null) {
                        projects.add(project);
                    }
                    ++n4;
                }
            }
            catch (IllegalStateException illegalStateException) {}
            ++n2;
        }
        return projects;
    }

    public static IWorkingSet getAssignedWorkingSet(IResource element) {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n3 = iAdaptableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable adaptable = iAdaptableArray[n4];
                if (adaptable.getAdapter(IResource.class) == element) {
                    return workingSet;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static List<IWorkingSet> getAssignedWorkingSets(IResource element) {
        ArrayList<IWorkingSet> list = new ArrayList<IWorkingSet>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n3 = iAdaptableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable adaptable = iAdaptableArray[n4];
                if (adaptable.getAdapter(IResource.class) == element) {
                    list.add(workingSet);
                }
                ++n4;
            }
            ++n2;
        }
        return list;
    }
}

