/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.extractors.TestCaseEvent;
import org.eclipse.titan.log.viewer.extractors.TestCaseEventDispatcher;
import org.eclipse.titan.log.viewer.extractors.TestCaseExtractor;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.LogFileHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class ExtractTestCasesAction
implements IRunnableWithProgress,
Observer {
    public static final String PROJECT_EXPLORER_VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private IFile logFile;
    private final TestCaseExtractor testCaseExtractor;
    private LogFileHandler logFileHandler;
    private LogFileMetaData logFileMetaData;
    private IProgressMonitor monitor;
    private int lastWorked;
    private TestCaseEventDispatcher testCaseEventDispatcher;

    public ExtractTestCasesAction(IFile logFile) {
        this.logFile = logFile;
        this.testCaseExtractor = new TestCaseExtractor();
        this.testCaseEventDispatcher = new TestCaseEventDispatcher();
        this.testCaseExtractor.addObserver(this.testCaseEventDispatcher);
        this.logFileHandler = new LogFileHandler(logFile);
        this.logFileMetaData = null;
        this.lastWorked = 0;
        this.testCaseEventDispatcher.addObserver(this);
    }

    public void run(IProgressMonitor pMonitor) throws InvocationTargetException, InterruptedException {
        this.monitor = pMonitor == null ? new NullProgressMonitor() : pMonitor;
        try {
            this.logFileMetaData = this.logFileHandler.autoDetect();
        }
        catch (TechnicalException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new UserException(e.getMessage()));
            return;
        }
        try {
            Object temp = this.logFile.getSessionProperty(Constants.EXTRACTION_RUNNING);
            if (temp != null && ((Boolean)temp).booleanValue()) {
                this.monitor.done();
                return;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new UserException(e.getMessage()));
        }
        try {
            this.monitor.beginTask(Messages.getString("ExtractTestCasesAction.0"), 100);
            boolean logFileHasChanged = LogFileCacheHandler.hasLogFileChanged(this.logFile);
            File propertyFile = LogFileCacheHandler.getPropertyFileForLogFile(this.logFile);
            if (logFileHasChanged) {
                if (this.updateLogFileIndex()) {
                    return;
                }
            } else {
                this.logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
                this.testCaseExtractor.extractTestCasesFromIndexedLogFile(this.logFile);
            }
        }
        catch (IOException e) {
            this.handleExtractingError(e);
        }
        catch (ClassNotFoundException e) {
            this.handleExtractingError(e);
        }
        catch (CoreException e) {
            this.handleExtractingError((Exception)((Object)e));
        }
        this.setExtractionRunningProperty(false);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart view = activePage.findView(ExtractTestCasesAction.PROJECT_EXPLORER_VIEW_ID);
                if (view instanceof CommonNavigator) {
                    CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
                    viewer.refresh((Object)ExtractTestCasesAction.this.logFile, true);
                    viewer.expandToLevel((Object)ExtractTestCasesAction.this.logFile, -1);
                }
            }
        });
        this.testCaseEventDispatcher.deleteObserver(this);
        this.testCaseExtractor.deleteObserver(this.testCaseEventDispatcher);
        this.monitor.done();
    }

    private boolean updateLogFileIndex() throws CoreException, IOException {
        this.logFile.setSessionProperty(Constants.EXTRACTION_RUNNING, (Object)true);
        ResourceUtils.refreshResources(Arrays.asList(this.logFile));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart view = activePage.findView(ExtractTestCasesAction.PROJECT_EXPLORER_VIEW_ID);
                if (view instanceof CommonNavigator) {
                    CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
                    viewer.refresh((Object)ExtractTestCasesAction.this.logFile, true);
                    viewer.collapseToLevel((Object)ExtractTestCasesAction.this.logFile, -1);
                }
            }
        });
        this.testCaseExtractor.extractTestCasesFromLogFile(this.logFileMetaData, this.monitor);
        if (this.monitor.isCanceled()) {
            LogFileCacheHandler.clearCache(this.logFile);
            this.monitor.done();
            this.setExtractionRunningProperty(false);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart view = activePage.findView(ExtractTestCasesAction.PROJECT_EXPLORER_VIEW_ID);
                    if (view instanceof CommonNavigator) {
                        CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
                        viewer.refresh((Object)ExtractTestCasesAction.this.logFile, true);
                        viewer.collapseToLevel((Object)ExtractTestCasesAction.this.logFile, -1);
                    }
                }
            });
            return true;
        }
        LogFileCacheHandler.fillCache(this.logFile, this.logFileMetaData, this.testCaseExtractor.getTestCases(), this.testCaseExtractor.getLogRecordIndexes());
        return false;
    }

    private void setExtractionRunningProperty(boolean on) {
        try {
            this.logFile.setSessionProperty(Constants.EXTRACTION_RUNNING, (Object)on);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    private void handleExtractingError(Exception e) throws InterruptedException {
        ErrorReporter.logExceptionStackTrace((Exception)e);
        String errorMsg = Messages.getString("ExtractTestCasesAction.5") + this.logFile.getName() + Messages.getString("ExtractTestCasesAction.6") + e.getMessage();
        TitanLogExceptionHandler.handleException(new TechnicalException(errorMsg));
        LogFileCacheHandler.clearCache(this.logFile);
        throw new InterruptedException(errorMsg);
    }

    @Override
    public void update(Observable observable, Object event) {
        if (event instanceof TestCaseEvent) {
            TestCaseEvent testCaseEvent = (TestCaseEvent)event;
            this.monitor.subTask(testCaseEvent.getTestCaseName());
            int worked = testCaseEvent.getProgress();
            this.monitor.worked(worked - this.lastWorked);
            this.lastWorked = worked;
        }
    }

    public List<TestCase> getTestCases() {
        return this.testCaseExtractor.getTestCases();
    }
}

