/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.search;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.SequentialLogFileReader;
import org.eclipse.titan.log.viewer.search.LogSearchResult;
import org.eclipse.titan.log.viewer.search.SearchPattern;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;

public class LogSearchQuery
implements ISearchQuery {
    private List<IFile> files;
    private SearchPattern pattern;
    private LogSearchResult result;

    public LogSearchQuery(List<IFile> files, SearchPattern pattern) {
        this.files = files;
        this.pattern = pattern;
        this.result = new LogSearchResult(this);
    }

    public IStatus run(IProgressMonitor monitor) {
        File indexFile;
        this.result.removeAll();
        int numOfRecords = 0;
        for (IFile logFile : this.files) {
            indexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
            numOfRecords += LogFileCacheHandler.getNumberOfLogRecordIndexes(indexFile);
        }
        monitor.beginTask("Searching", numOfRecords);
        for (IFile logFile : this.files) {
            if (monitor.isCanceled()) break;
            if (LogFileCacheHandler.hasLogFileChanged(logFile) && !LogFileCacheHandler.processLogFile(logFile, (IProgressMonitor)new NullProgressMonitor(), true)) continue;
            indexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
            try {
                LogRecordIndex[] indexes = LogFileCacheHandler.readLogRecordIndexFile(indexFile, 0, LogFileCacheHandler.getNumberOfLogRecordIndexes(indexFile));
                SequentialLogFileReader reader = new SequentialLogFileReader(logFile.getLocationURI(), indexes);
                monitor.subTask("Filtering");
                this.filterRecords(monitor, logFile, reader);
                monitor.done();
            }
            catch (ParseException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(logFile.getName() + ": Could not parse the log file. Reason: " + e.getMessage()));
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(logFile.getName() + ": Error while searching. Reason: " + e.getMessage()));
            }
        }
        monitor.done();
        return new Status(0, "org.eclipse.titan.log.viewer", 0, "Search done.", null);
    }

    private void filterRecords(IProgressMonitor monitor, IFile logFile, SequentialLogFileReader reader) throws ParseException, IOException {
        LogRecord record = reader.getNext();
        while (reader.hasNext()) {
            if (this.pattern.match(record)) {
                this.result.addMatch(new Match((Object)logFile, 1, record.getRecordNumber(), 1));
            }
            if (monitor.isCanceled()) break;
            monitor.worked(1);
            record = reader.getNext();
        }
    }

    public String getLabel() {
        return "TITAN Log Search";
    }

    public SearchPattern getPattern() {
        return this.pattern;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }
}

