/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.Messages;

public class LogFileHandler {
    private LogFileMetaData fileMetaInfo = new LogFileMetaData();

    public LogFileHandler(URI filePath, String projectName, String projectRelativePath) {
        this.fileMetaInfo.setFilePath(filePath);
        this.fileMetaInfo.setProjectName(projectName);
        this.fileMetaInfo.setProjectRelativePath(projectRelativePath);
        this.fileMetaInfo.setVersion("4.0.0");
    }

    public LogFileHandler(IFile logFile) {
        this(logFile.getLocationURI(), logFile.getProject().getName(), File.separator + logFile.getProject().getName() + File.separator + logFile.getProjectRelativePath().toOSString());
    }

    private String getTimeStampFormat(String logString) {
        if (logString.length() < "s.SSSSSS".length()) {
            return null;
        }
        String[] strings = logString.split("\\s");
        if (strings.length < 1) {
            return null;
        }
        String seconds = strings[0];
        if (Pattern.matches("(0|[1-9][0-9]*)\\.[0-9]{6}", seconds)) {
            return "s.SSSSSS";
        }
        if (logString.length() < "HH:mm:ss.SSSSSS".length()) {
            return null;
        }
        String time = logString.substring(0, "HH:mm:ss.SSSSSS".length());
        if (Pattern.matches("([01][0-9]|2[0-3])\\:[0-5][0-9]\\:[0-5][0-9]\\.[0-9]{6}", time)) {
            return "HH:mm:ss.SSSSSS";
        }
        if (logString.length() < "yyyy/MMM/dd HH:mm:ss.SSSSSS".length()) {
            return null;
        }
        String date = logString.substring(0, "yyyy/MMM/dd HH:mm:ss.SSSSSS".length());
        if (Pattern.matches("[12][0-9]{3}\\/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\/([012][0-9]|30|31)\\ ([01][0-9]|2[0-3])\\:[0-5][0-9]\\:[0-5][0-9]\\.[0-9]{6}", date)) {
            return "yyyy/MMM/dd HH:mm:ss.SSSSSS";
        }
        return null;
    }

    public static String validateTimeStamp(String logLine, String format) {
        switch (format.length()) {
            case 27: {
                String temp;
                if (logLine.length() < "yyyy/MMM/dd HH:mm:ss.SSSSSS".length() || !LogFileHandler.validateDateTime(temp = logLine.substring(0, "yyyy/MMM/dd HH:mm:ss.SSSSSS".length()))) break;
                return temp;
            }
            case 15: {
                String temp;
                if (logLine.length() < "HH:mm:ss.SSSSSS".length() || !LogFileHandler.validateTime(temp = logLine.substring(0, "HH:mm:ss.SSSSSS".length()))) break;
                return temp;
            }
            case 8: {
                if (logLine.length() < "s.SSSSSS".length()) break;
                String[] strings = logLine.split("\\s");
                if (strings.length < 1) {
                    return null;
                }
                String temp = strings[0];
                if (!LogFileHandler.validateSeconds(temp)) break;
                return temp;
            }
        }
        return null;
    }

    private static boolean validateDateTime(String dateFormat) {
        return Pattern.matches("[12][0-9]{3}\\/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\/([012][0-9]|30|31)\\ ([01][0-9]|2[0-3])\\:[0-5][0-9]\\:[0-5][0-9]\\.[0-9]{6}", dateFormat);
    }

    private static boolean validateTime(String timeFormat) {
        return Pattern.matches("([01][0-9]|2[0-3])\\:[0-5][0-9]\\:[0-5][0-9]\\.[0-9]{6}", timeFormat);
    }

    private static boolean validateSeconds(String secondFormat) {
        return Pattern.matches("(0|[1-9][0-9]*)\\.[0-9]{6}", secondFormat);
    }

    public LogFileMetaData autoDetect() throws TechnicalException {
        String fileExtension;
        String logExt;
        String logLine = null;
        BufferedReader bufferedReader = null;
        File logFile = new File(this.fileMetaInfo.getFilePath());
        if (!logFile.exists()) {
            throw new TechnicalException(Messages.getString("LogFileHandler.6"));
        }
        int fileSize = logFile.getName().length();
        if (fileSize > (logExt = ".log").length() && !(fileExtension = logFile.getName().substring(fileSize - logExt.length(), fileSize)).equalsIgnoreCase(logExt)) {
            throw new TechnicalException(Messages.getString("LogFileHandler.4"));
        }
        if (logFile.length() == 0L) {
            throw new TechnicalException(Messages.getString("LogFileHandler.0"));
        }
        if (!logFile.canRead()) {
            throw new TechnicalException(Messages.getString("LogFileHandler.5"));
        }
        try {
            String timeStampFormat;
            bufferedReader = new BufferedReader(new FileReader(logFile));
            try {
                logLine = bufferedReader.readLine();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                throw new TechnicalException(Messages.getString("LogFileHandler.5"));
            }
            String string = timeStampFormat = logLine != null ? this.getTimeStampFormat(logLine) : null;
            if (timeStampFormat == null) {
                throw new TechnicalException(Messages.getString("LogFileHandler.1"));
            }
            this.fileMetaInfo.setTimeStampFormat(timeStampFormat);
            logLine = logLine.substring(timeStampFormat.length(), logLine.length()).trim();
            String[] logLineArray = logLine.split(" ");
            if (logLineArray.length < 1) {
                throw new TechnicalException(Messages.getString("LogFileHandler.2"));
            }
            this.fileMetaInfo.setHasLoggedEventTypes(this.isEventTypePresent(logLine));
            String executionMode = this.getExecutionMode(logLine);
            if (executionMode == null) {
                throw new TechnicalException(Messages.getString("LogFileHandler.3"));
            }
            this.fileMetaInfo.setExecutionMode(executionMode);
            this.fileMetaInfo.setSize(logFile.length());
            this.fileMetaInfo.setLastModified(logFile.lastModified());
            this.fileMetaInfo.setFileFormat(1);
        }
        catch (FileNotFoundException e) {
            try {
                throw new TechnicalException("File not found: " + this.fileMetaInfo.getFilePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)bufferedReader);
        return this.fileMetaInfo;
    }

    private boolean isEventTypePresent(String logLine) {
        SortedMap<String, String[]> eventCategories = Constants.EVENT_CATEGORIES;
        Set<String> categories = eventCategories.keySet();
        for (String category : categories) {
            if (!logLine.contains(category)) continue;
            return true;
        }
        return false;
    }

    private String getExecutionMode(String logLine) {
        int i;
        for (i = 0; i < Constants.MESSAGE_START_LINES_SINGLE.length; ++i) {
            if (!logLine.contains(Constants.MESSAGE_START_LINES_SINGLE[i])) continue;
            return "SINGLE";
        }
        for (i = 0; i < Constants.MESSAGE_START_LINES_PARALLEL.length; ++i) {
            if (!logLine.contains(Constants.MESSAGE_START_LINES_PARALLEL[i])) continue;
            return "PARALLEL";
        }
        return "PARALLEL";
    }
}

