/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;

public class TestComponent {
    private String name;
    private String reference;
    private String alternative;
    private String verdict;
    private Map<String, Set<String>> ports;
    private int recordNumber;

    public TestComponent(EventObject event, String pAlternative) {
        this.name = event.getName();
        this.reference = event.getReference();
        this.alternative = pAlternative;
        this.ports = new HashMap<String, Set<String>>();
        this.verdict = "none";
        this.recordNumber = event.getRecordNumber();
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public String getAlternative() {
        return this.alternative;
    }

    public String getVerdict() {
        return this.verdict;
    }

    public void addFromEntry(String localPort, String reference) {
        Set<String> components = this.ports.get(localPort);
        if (components == null) {
            components = new HashSet<String>();
            this.ports.put(localPort, components);
        }
        components.add(reference);
    }

    public Set<String> getMappedFromReference(String localPort) {
        return this.ports.get(localPort);
    }

    public void setVerdict(String pVerdict) {
        this.verdict = pVerdict;
    }

    public void setName(String name) {
        this.name = name;
    }
}

