/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.navigator;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.actions.ExtractTestCasesAction;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.extractors.TestCaseExtractor;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class LogFileContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] emptyResult = new Object[]{};
        if (!(parentElement instanceof IFile)) {
            return emptyResult;
        }
        IFile logFile = (IFile)parentElement;
        if (!logFile.exists()) {
            return emptyResult;
        }
        String fileExtension = logFile.getFileExtension();
        if (fileExtension == null || !fileExtension.equals("log")) {
            return emptyResult;
        }
        try {
            Object temp = logFile.getSessionProperty(Constants.EXTRACTION_RUNNING);
            if (temp != null && ((Boolean)temp).booleanValue()) {
                return emptyResult;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new UserException(e.getMessage()));
        }
        if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
            this.handleLogFileChange(logFile);
            return emptyResult;
        }
        try {
            final TestCaseExtractor extractor = new TestCaseExtractor();
            extractor.extractTestCasesFromIndexedLogFile(logFile);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    if (view instanceof CommonNavigator) {
                        CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
                        for (TestCase testCase : extractor.getTestCases()) {
                            viewer.expandToLevel((Object)testCase, -1);
                            viewer.refresh((Object)testCase, true);
                        }
                    }
                }
            });
            return extractor.getTestCases().toArray();
        }
        catch (Exception e) {
            LogFileCacheHandler.clearCache(logFile);
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return emptyResult;
        }
    }

    private void handleLogFileChange(final IFile logFile) {
        WorkspaceJob job = new WorkspaceJob("Testcase extraction from logfile " + logFile.getProjectRelativePath().toString()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ExtractTestCasesAction extractTestCasesAction = new ExtractTestCasesAction(logFile);
                try {
                    extractTestCasesAction.run(monitor);
                }
                catch (InvocationTargetException e) {
                    LogFileCacheHandler.clearCache(logFile);
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                catch (InterruptedException e) {
                    LogFileCacheHandler.clearCache(logFile);
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.setRule(LogFileCacheHandler.getSchedulingRule(logFile));
        job.schedule();
    }

    public Object getParent(Object element) {
        if (element instanceof TestCase) {
            return ((TestCase)element).getLogFile();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile && "log".equals(((IFile)element).getFileExtension());
    }
}

