/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.hostcontrollers;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.fieldeditors.TITANResourceLocator;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.executor.graphics.ImageCache;

public final class HostControllerDialog
extends Dialog {
    private static final String EMPTYSTRING = "";
    private static final String DEFAULT_HOSTNAME = "Rhea";
    private String hostName;
    private String workingdirectory;
    private String executable;
    private String command;
    private Text hostNameText;
    private TITANResourceLocator workingdirectoryText;
    private TITANResourceLocator executableText;
    private Text commandText;
    private String title;
    private Label exampleCommand;
    private final IProject project;
    private final Image[] images = new Image[]{ImageCache.getImageDescriptor("host.gif").createImage(), ImageCache.getImageDescriptor("folder.gif").createImage(), ImageCache.getImageDescriptor("executable.gif").createImage(), ImageCache.getImageDescriptor("command.gif").createImage(), ImageCache.getImageDescriptor("titan.gif").createImage()};
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            HostControllerDialog.this.validate();
            HostControllerDialog.this.updateExampleText();
        }
    };

    public HostControllerDialog(Shell shell, IProject project, String title) {
        super(shell);
        this.project = project;
        this.title = title;
        this.hostName = EMPTYSTRING;
        this.workingdirectory = EMPTYSTRING;
        this.executable = EMPTYSTRING;
        this.command = EMPTYSTRING;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    public void setHostName(String value) {
        this.hostName = value;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setWorkingdirectory(String value) {
        this.workingdirectory = value;
    }

    public String getWorkingdirectory() {
        return this.workingdirectory;
    }

    public void setExecutable(String value) {
        this.executable = value;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setCommand(String value) {
        this.command = value;
    }

    public String getCommand() {
        return this.command;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (null != this.title) {
            shell.setText(this.title);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Image image : HostControllerDialog.this.images) {
                    image.dispose();
                }
            }
        });
    }

    private void validate() {
        if (null != this.getButton(0)) {
            this.getButton(0).setEnabled(0 != this.commandText.getText().length());
        }
    }

    private void updateExampleText() {
        String hostName;
        String example = "example command: " + this.commandText.getText();
        example = example.replace("%Host", this.hostNameText.getText());
        URI workingDirPath = null == this.project ? URIUtil.toURI((String)this.workingdirectoryText.getStringValue()) : TITANPathUtilities.resolvePathURI((String)this.workingdirectoryText.getStringValue(), (String)this.project.getLocation().toOSString());
        example = example.replace("%Workingdirectory", URIUtil.toPath((URI)workingDirPath).toOSString());
        URI executablePath = null == this.project ? URIUtil.toURI((String)this.executableText.getStringValue()) : TITANPathUtilities.resolvePathURI((String)this.executableText.getStringValue(), (String)this.project.getLocation().toOSString());
        String path = PathUtil.getRelativePath((String)URIUtil.toPath((URI)workingDirPath).toOSString(), (String)URIUtil.toPath((URI)executablePath).toOSString());
        example = example.replace("%Executable", path);
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = DEFAULT_HOSTNAME;
        }
        example = example.replace("%MCHost", hostName);
        example = example.replace("%MCPort", String.valueOf(1234));
        this.exampleCommand.setText(example);
    }

    protected void okPressed() {
        this.hostName = this.hostNameText.getText();
        this.workingdirectory = this.workingdirectoryText.getStringValue();
        this.executable = this.executableText.getStringValue();
        this.command = this.commandText.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createHostNameArea(container);
        this.createWorkingdirectoryArea(container);
        this.createExecutableArea(container);
        this.createCommandArea(container);
        this.exampleCommand = new Label(container, 0);
        this.exampleCommand.setText("example command: ");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this.exampleCommand.setLayoutData((Object)data);
        this.exampleCommand.setToolTipText("An example for the final command.\nThis will be prefixed with sh -c");
        Dialog.applyDialogFont((Control)container);
        this.validate();
        this.updateExampleText();
        return container;
    }

    protected void createHostNameArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        Label label = new Label(panel, 0);
        label.setLayoutData((Object)new GridData(32));
        label.setImage(this.images[0]);
        Label hostNameLabel = new Label(panel, 0);
        hostNameLabel.setText("hostname:");
        hostNameLabel.setLayoutData((Object)new GridData(32));
        hostNameLabel.setToolTipText("The value for %Host");
        this.hostNameText = new Text(panel, 2052);
        this.hostNameText.setLayoutData((Object)new GridData(768));
        this.hostNameText.setText(this.hostName);
        hostNameLabel.setSize(hostNameLabel.getSize().x, this.hostNameText.getSize().y);
        this.hostNameText.addModifyListener(this.modifyListener);
    }

    protected void createWorkingdirectoryArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        this.workingdirectoryText = null == this.project ? new TITANResourceLocator("working directory:", panel, 2, EMPTYSTRING) : new TITANResourceLocator("working directory:", panel, 2, this.project.getLocation().toOSString());
        this.workingdirectoryText.getTextControl(panel).setToolTipText("The value for %Workingdirectory");
        this.workingdirectoryText.setStringValue(this.workingdirectory);
        this.workingdirectoryText.getTextControl(panel).addModifyListener(this.modifyListener);
    }

    protected void createExecutableArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        this.executableText = null == this.project ? new TITANResourceLocator("executable:", panel, 2, EMPTYSTRING) : new TITANResourceLocator("executable:", panel, 2, this.project.getLocation().toOSString());
        this.executableText.getTextControl(panel).setToolTipText("The value for %Executable");
        this.executableText.setStringValue(this.executable);
        this.executableText.getTextControl(panel).addModifyListener(this.modifyListener);
    }

    protected void createCommandArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        Label label = new Label(panel, 0);
        label.setLayoutData((Object)new GridData(32));
        label.setImage(this.images[3]);
        Label commandLabel = new Label(panel, 0);
        commandLabel.setText("command:");
        commandLabel.setLayoutData((Object)new GridData(32));
        commandLabel.setToolTipText("The command to execute.\nAdditonally %MCHost and %MCPort is replaced by maincontroller provided data");
        this.commandText = new Text(panel, 2052);
        this.commandText.setLayoutData((Object)new GridData(768));
        this.commandText.setText(this.command);
        commandLabel.setSize(commandLabel.getSize().x, this.commandText.getSize().y);
        this.commandText.addModifyListener(this.modifyListener);
    }
}

