/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.hostcontrollers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.HostController;
import org.eclipse.titan.executor.TITANDebugConsole;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.tabpages.hostcontrollers.HostControllerContentProvider;
import org.eclipse.titan.executor.tabpages.hostcontrollers.HostControllerDialog;
import org.eclipse.titan.executor.tabpages.hostcontrollers.HostControllerLabelProvider;
import org.eclipse.titan.executor.tabpages.maincontroller.BaseMainControllerTab;
import org.eclipse.ui.console.MessageConsoleStream;

public final class HostControllersTab
extends AbstractLaunchConfigurationTab {
    private TableViewer hostViewer;
    private Composite mainComposite;
    private Composite tableComposite;
    private final ILaunchConfigurationTabGroup tabGroup;
    private static final String[] HOST_TABLE_COLUMN_HEADERS = new String[]{"Host", "Working directory", "Executable", "Command"};
    private final ColumnLayoutData[] hostTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(1, 75), new ColumnWeightData(2, 150), new ColumnWeightData(2, 100), new ColumnWeightData(2, 100)};
    private final Image[] columnImages = new Image[]{ImageCache.getImageDescriptor("host.gif").createImage(), ImageCache.getImageDescriptor("folder.gif").createImage(), ImageCache.getImageDescriptor("executable.gif").createImage(), ImageCache.getImageDescriptor("command.gif").createImage()};
    private Button addHostButton;
    private Button editHostButton;
    private Button copyHostButton;
    private Button removeHostButton;
    private Button initFromProject;

    public HostControllersTab(ILaunchConfigurationTabGroup tabGroup) {
        this.tabGroup = tabGroup;
    }

    public void dispose() {
        for (Image columnImage : this.columnImages) {
            columnImage.dispose();
        }
        this.hostViewer = null;
        if (null != this.mainComposite) {
            this.mainComposite.dispose();
            this.mainComposite = null;
        }
        if (null != this.tableComposite) {
            this.tableComposite.dispose();
            this.tableComposite = null;
        }
        if (null != this.addHostButton) {
            this.addHostButton.dispose();
            this.addHostButton = null;
        }
        if (null != this.editHostButton) {
            this.editHostButton.dispose();
            this.editHostButton = null;
        }
        if (null != this.copyHostButton) {
            this.copyHostButton.dispose();
            this.copyHostButton = null;
        }
        if (null != this.removeHostButton) {
            this.removeHostButton.dispose();
            this.removeHostButton = null;
        }
        if (null != this.initFromProject) {
            this.initFromProject.dispose();
            this.initFromProject = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.setControl((Control)this.mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)gridData);
        this.mainComposite.setFont(parent.getFont());
        this.createHostControllersTable(this.mainComposite);
        this.createTableButtons(this.mainComposite);
        Dialog.applyDialogFont((Control)this.mainComposite);
    }

    private void createHostControllersTable(Composite parent) {
        this.tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.tableComposite.setLayout((Layout)layout);
        this.tableComposite.setLayoutData((Object)data);
        this.tableComposite.setFont(parent.getFont());
        Label label = new Label(this.tableComposite, 0);
        label.setFont(parent.getFont());
        label.setText("Host Controllers to use:");
        this.hostViewer = new TableViewer(this.tableComposite, 68354);
        Table table = this.hostViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.hostViewer.getControl().setLayoutData((Object)data);
        this.hostViewer.setContentProvider((IContentProvider)new HostControllerContentProvider());
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new HostControllerLabelProvider());
        this.hostViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HostControllersTab.this.handleEditButtonSelected();
            }
        });
        for (int i = 0; i < HOST_TABLE_COLUMN_HEADERS.length; ++i) {
            tableLayout.addColumnData(this.hostTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.setText(HOST_TABLE_COLUMN_HEADERS[i]);
            tc.setImage(this.columnImages[i]);
        }
    }

    private void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData data = new GridData(130);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setFont(parent.getFont());
        this.createVerticalSpacer(buttonComposite, 1);
        this.addHostButton = this.createPushButton(buttonComposite, "New...", null);
        this.addHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HostControllersTab.this.handleNewButtonSelected();
            }
        });
        this.editHostButton = this.createPushButton(buttonComposite, "Edit...", null);
        this.editHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HostControllersTab.this.handleEditButtonSelected();
            }
        });
        this.copyHostButton = this.createPushButton(buttonComposite, "Copy...", null);
        this.copyHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HostControllersTab.this.handleCopySelected();
            }
        });
        this.removeHostButton = this.createPushButton(buttonComposite, "Remove...", null);
        this.removeHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HostControllersTab.this.handleRemoveSelected();
            }
        });
        this.initFromProject = this.createPushButton(buttonComposite, "Init...", null);
        this.initFromProject.setToolTipText("Clears the list and tries to add a single host controller with properties set for the project set on the Main Controller page");
        this.initFromProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HostControllersTab.this.handleInitialization();
            }
        });
    }

    private void handleNewButtonSelected() {
        HostControllerDialog dialog = new HostControllerDialog(this.getShell(), this.getProject(), "Host Controller");
        dialog.setHostName("");
        dialog.setWorkingdirectory("");
        dialog.setExecutable("");
        dialog.setCommand("rsh %Host cd %Workingdirectory; %Executable %MCHost %MCPort");
        if (dialog.open() != 0) {
            return;
        }
        this.hostViewer.add((Object)new HostController(dialog.getHostName(), dialog.getWorkingdirectory(), dialog.getExecutable(), dialog.getCommand()));
        this.updateLaunchConfigurationDialog();
    }

    private void handleEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.hostViewer.getSelection();
        HostController controller = (HostController)sel.getFirstElement();
        if (null == controller) {
            return;
        }
        String host = controller.host();
        String workingDirectory = controller.workingdirectory();
        String executable = controller.executable();
        String command = controller.command();
        HostControllerDialog dialog = new HostControllerDialog(this.getShell(), this.getProject(), "Host Controller");
        dialog.setHostName(host);
        dialog.setWorkingdirectory(workingDirectory);
        dialog.setExecutable(executable);
        dialog.setCommand(command);
        if (dialog.open() != 0) {
            return;
        }
        controller.configure(dialog.getHostName(), dialog.getWorkingdirectory(), dialog.getExecutable(), dialog.getCommand());
        this.hostViewer.refresh((Object)controller, true);
        this.updateLaunchConfigurationDialog();
    }

    private void handleCopySelected() {
        IStructuredSelection sel = (IStructuredSelection)this.hostViewer.getSelection();
        HostController controller = (HostController)sel.getFirstElement();
        if (null == controller) {
            return;
        }
        this.hostViewer.add((Object)controller.clone());
        this.updateLaunchConfigurationDialog();
    }

    private void handleRemoveSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.hostViewer.getSelection();
        this.hostViewer.getControl().setRedraw(false);
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            this.hostViewer.remove(i.next());
        }
        this.hostViewer.getControl().setRedraw(true);
        this.updateLaunchConfigurationDialog();
    }

    private IProject getProject() {
        ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
        BaseMainControllerTab maincontrollerTab = null;
        for (ILaunchConfigurationTab tab : tabs) {
            if (!(tab instanceof BaseMainControllerTab)) continue;
            maincontrollerTab = (BaseMainControllerTab)tab;
        }
        if (null == maincontrollerTab) {
            return null;
        }
        return maincontrollerTab.getProject();
    }

    private void handleInitialization() {
        MessageConsoleStream stream = TITANDebugConsole.getConsole().newMessageStream();
        stream.println("initializing a host controller");
        IProject project = this.getProject();
        if (null == project) {
            return;
        }
        stream.println(project.getName());
        try {
            TableItem[] items;
            String workingdirectory = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
            String executable = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            if (null == executable || 0 == executable.length()) {
                executable = workingdirectory + "/" + project.getName();
                if ("win32".equals(Platform.getOS())) {
                    executable = executable + ".exe";
                }
            }
            stream.println(workingdirectory);
            stream.println(executable);
            for (TableItem item : items = this.hostViewer.getTable().getItems()) {
                this.hostViewer.remove(item.getData());
            }
            this.hostViewer.add((Object)new HostController("localhost", workingdirectory, executable, "cd %Workingdirectory; %Executable %MCHost %MCPort"));
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public String getName() {
        return "HostControllerTab";
    }

    public Image getImage() {
        return ImageCache.getImageDescriptor("host.gif").createImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.hostViewer.setInput((Object)configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TableItem[] items = this.hostViewer.getTable().getItems();
        ArrayList<String> hostNames = new ArrayList<String>();
        ArrayList<String> hostWorkingDirectories = new ArrayList<String>();
        ArrayList<String> hostExecutables = new ArrayList<String>();
        ArrayList<String> hostLoginCommands = new ArrayList<String>();
        for (TableItem item : items) {
            HostController controller = (HostController)item.getData();
            hostNames.add(controller.host());
            hostWorkingDirectories.add(controller.workingdirectory());
            hostExecutables.add(controller.executable());
            hostLoginCommands.add(controller.command());
        }
        if (!hostNames.isEmpty()) {
            configuration.setAttribute("org.eclipse.titan.executor.hostNames", hostNames);
            configuration.setAttribute("org.eclipse.titan.executor.hostWorkingDirectories", hostWorkingDirectories);
            configuration.setAttribute("org.eclipse.titan.executor.hostExecutables", hostExecutables);
            configuration.setAttribute("org.eclipse.titan.executor.hostCommands", hostLoginCommands);
        } else {
            configuration.setAttribute("org.eclipse.titan.executor.hostNames", (List)null);
            configuration.setAttribute("org.eclipse.titan.executor.hostWorkingDirectories", (List)null);
            configuration.setAttribute("org.eclipse.titan.executor.hostExecutables", (List)null);
            configuration.setAttribute("org.eclipse.titan.executor.hostCommands", (List)null);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.titan.executor.hostNames", (List)null);
        configuration.setAttribute("org.eclipse.titan.executor.hostWorkingDirectories", (List)null);
        configuration.setAttribute("org.eclipse.titan.executor.hostExecutables", (List)null);
        configuration.setAttribute("org.eclipse.titan.executor.hostCommands", (List)null);
    }

    public static boolean initLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration) {
        ArrayList<String> hostNames = new ArrayList<String>();
        ArrayList<String> hostWorkingDirectories = new ArrayList<String>();
        ArrayList<String> hostExecutables = new ArrayList<String>();
        ArrayList<String> hostLoginCommands = new ArrayList<String>();
        hostNames.add("localhost");
        try {
            String workingDirectoryPath = configuration.getAttribute("org.eclipse.titan.executor.workingdirectoryPath", (String)null);
            hostWorkingDirectories.add(workingDirectoryPath);
            String executablePath = configuration.getAttribute("org.eclipse.titan.executor.executableFilePath", (String)null);
            hostExecutables.add(executablePath);
        }
        catch (CoreException e) {
            return false;
        }
        hostLoginCommands.add("cd %Workingdirectory; %Executable %MCHost %MCPort");
        configuration.setAttribute("org.eclipse.titan.executor.hostNames", hostNames);
        configuration.setAttribute("org.eclipse.titan.executor.hostWorkingDirectories", hostWorkingDirectories);
        configuration.setAttribute("org.eclipse.titan.executor.hostExecutables", hostExecutables);
        configuration.setAttribute("org.eclipse.titan.executor.hostCommands", hostLoginCommands);
        return true;
    }
}

