/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.maincontroller;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.fieldeditors.TITANResourceLocator;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.executor.TITANConsole;
import org.eclipse.titan.executor.TITANDebugConsole;
import org.eclipse.titan.executor.designerconnection.DynamicLinkingHelper;
import org.eclipse.titan.executor.designerconnection.EnvironmentHelper;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.tabpages.testset.TestSetTab;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class BaseMainControllerTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY = "";
    private static final String NAME = "Basic Main Controller options";
    private static final String PROJECT = "Project (REQUIRED):";
    private static final String PROJECT_TOOLTIP = "This field is required.\nWhen an existing project is selected and the Designer plug-in is also present the working directory and executable fields are filled out automatically\n  with the values set as project properties.";
    private static final String WORKING_DIR = "Working directory:";
    private static final String WORKING_DIR_REQUIRED = "Working directory (REQUIRED):";
    private static final String WORKING_DIR_TOOLTIP = "The directory the main controller should be started from.";
    private static final String EXECUTABLE = "Executable (REQUIRED):";
    private static final String EXECUTABLE_TOOLTIP = "This field is required.\nThe executable file used to make the creation and validation of testsets possible.";
    private static final String EXECUTABLE_REQUIRED = "Executable (REQUIRED):";
    private static final String EXECUTABLE_REQUIRED_TOOLTIP = "The executable file used to execute testcases and to make the creation and validation of testsets possible.";
    private static final String CONFIGFILE = "Configuration file (REQUIRED):";
    private static final String CONFIGFILE_TOOLTIP = "This field is required.\nThe runtime configuration file used to describe the runtime behaviour of the executable test program.";
    private static final String BROWSE_WORKSPACE = "Browse Workspace..";
    private BasicProjectSelectorListener generalListener;
    private ILaunchConfigurationTabGroup tabGroup;
    private ILaunchConfigurationWorkingCopy lastConfiguration;
    protected Text projectNameText;
    private Group workingDirGroup;
    protected TITANResourceLocator workingdirectoryText;
    private Group executableGroup;
    protected TITANResourceLocator configurationFileText;
    private Group configFileGroup;
    protected TITANResourceLocator executableFileText;
    private Button projectSelectionButton;
    private Button automaticExecuteSectionExecution;
    protected boolean projectIsValid;
    protected boolean workingDirectoryIsValid;
    protected boolean configurationFileIsValid;
    protected boolean executableFileIsValid;
    protected boolean executableIsExecutable;
    protected boolean executableIsForSingleMode = false;
    protected boolean workingDirectoryRequired = false;
    protected boolean executableRequired = false;
    protected List<Throwable> exceptions = new ArrayList<Throwable>();

    protected BaseMainControllerTab(ILaunchConfigurationTabGroup tabGroup) {
        this.tabGroup = tabGroup;
        this.generalListener = new BasicProjectSelectorListener();
        this.projectIsValid = true;
        this.workingDirectoryIsValid = false;
        this.configurationFileIsValid = false;
        this.executableFileIsValid = false;
    }

    public final void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.numColumns = 1;
        pageComposite.setLayout((Layout)pageCompositeLayout);
        GridData pageCompositeGridData = new GridData();
        pageCompositeGridData.horizontalAlignment = 4;
        pageCompositeGridData.grabExcessHorizontalSpace = true;
        pageCompositeGridData.grabExcessVerticalSpace = true;
        pageComposite.setLayoutData((Object)pageCompositeGridData);
        this.createProjectEditor(pageComposite);
        this.createWorkingdirectoryEditor(pageComposite);
        this.createExecutableEditor(pageComposite);
        this.createConfigurationEditor(pageComposite);
        this.setControl((Control)pageComposite);
    }

    public final String getName() {
        return NAME;
    }

    public final Image getImage() {
        return ImageCache.getImage("titan.gif");
    }

    public final void initializeFrom(ILaunchConfiguration configuration) {
        try {
            IProject project;
            boolean tempBoolean;
            this.lastConfiguration = configuration.getWorkingCopy();
            String temp = configuration.getAttribute("org.eclipse.titan.executor.projectName", EMPTY);
            if (!temp.equals(this.projectNameText.getText())) {
                this.projectNameText.setText(temp);
            }
            if (!(temp = configuration.getAttribute("org.eclipse.titan.executor.workingdirectoryPath", EMPTY)).equals(this.workingdirectoryText.getStringValue())) {
                this.workingdirectoryText.setStringValue(temp);
            }
            if (!(temp = configuration.getAttribute("org.eclipse.titan.executor.executableFilePath", EMPTY)).equals(this.executableFileText.getStringValue())) {
                this.executableFileText.setStringValue(temp);
            }
            if (!(temp = configuration.getAttribute("org.eclipse.titan.executor.configurationFilePath", EMPTY)).equals(this.configurationFileText.getStringValue())) {
                this.configurationFileText.setStringValue(temp);
            }
            if ((tempBoolean = configuration.getAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", false)) != this.automaticExecuteSectionExecution.getSelection()) {
                this.automaticExecuteSectionExecution.setSelection(tempBoolean);
            }
            if ((project = this.getProject()) == null) {
                return;
            }
            String projectPath = project.getLocation().toOSString();
            this.workingdirectoryText.setRootPath(projectPath);
            this.configurationFileText.setRootPath(projectPath);
            this.executableFileText.setRootPath(projectPath);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.titan.executor.projectName", this.projectNameText.getText());
        configuration.setAttribute("org.eclipse.titan.executor.workingdirectoryPath", this.workingdirectoryText.getStringValue());
        configuration.setAttribute("org.eclipse.titan.executor.executableFilePath", this.executableFileText.getStringValue());
        configuration.setAttribute("org.eclipse.titan.executor.configurationFilePath", this.configurationFileText.getStringValue());
        configuration.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", this.automaticExecuteSectionExecution.getSelection());
        IProject project = this.getProject();
        configuration.setMappedResources(new IResource[]{project});
    }

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.titan.executor.projectName", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.workingdirectoryPath", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.executableFilePath", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.configurationFilePath", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", false);
        configuration.setMappedResources(new IResource[0]);
    }

    protected final void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(PROJECT);
        group.setToolTipText(PROJECT_TOOLTIP);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectNameText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.projectNameText.setLayoutData((Object)gd);
        this.projectNameText.setFont(font);
        this.projectNameText.addModifyListener((ModifyListener)this.generalListener);
        this.projectSelectionButton = this.createPushButton((Composite)group, BROWSE_WORKSPACE, null);
        this.projectSelectionButton.addSelectionListener((SelectionListener)this.generalListener);
    }

    protected final void createWorkingdirectoryEditor(Composite parent) {
        Font font = parent.getFont();
        this.workingDirGroup = new Group(parent, 0);
        if (this.workingDirectoryRequired) {
            this.workingDirGroup.setText(WORKING_DIR_REQUIRED);
        } else {
            this.workingDirGroup.setText(WORKING_DIR);
        }
        this.workingDirGroup.setToolTipText(WORKING_DIR_TOOLTIP);
        GridData gd = new GridData(768);
        this.workingDirGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.workingDirGroup.setLayout((Layout)layout);
        this.workingDirGroup.setFont(font);
        IProject project = this.getProject();
        this.workingdirectoryText = project == null ? new TITANResourceLocator("working directory:", (Composite)this.workingDirGroup, 2, EMPTY) : new TITANResourceLocator("working directory:", (Composite)this.workingDirGroup, 2, this.getProject().getLocation().toOSString());
        this.workingdirectoryText.getLabelControl((Composite)this.workingDirGroup).setToolTipText("The location of the working directory. Where the build process will take place");
        this.workingdirectoryText.getTextControl((Composite)this.workingDirGroup).addModifyListener((ModifyListener)this.generalListener);
    }

    protected final void createExecutableEditor(Composite parent) {
        Font font = parent.getFont();
        this.executableGroup = new Group(parent, 0);
        if (this.executableRequired) {
            this.executableGroup.setText("Executable (REQUIRED):");
            this.executableGroup.setToolTipText(EXECUTABLE_REQUIRED_TOOLTIP);
        } else {
            this.executableGroup.setText("Executable (REQUIRED):");
            this.executableGroup.setToolTipText(EXECUTABLE_TOOLTIP);
        }
        GridData gd = new GridData(768);
        this.executableGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.executableGroup.setLayout((Layout)layout);
        this.executableGroup.setFont(font);
        IProject project = this.getProject();
        this.executableFileText = project == null ? new TITANResourceLocator("Executable (REQUIRED):", (Composite)this.executableGroup, 1, EMPTY) : new TITANResourceLocator("Executable (REQUIRED):", (Composite)this.executableGroup, 1, this.getProject().getLocation().toOSString());
        this.executableFileText.getLabelControl((Composite)this.executableGroup).setToolTipText(EXECUTABLE_TOOLTIP);
        this.executableFileText.getTextControl((Composite)this.executableGroup).addModifyListener((ModifyListener)this.generalListener);
    }

    protected final void createConfigurationEditor(Composite parent) {
        Font font = parent.getFont();
        this.configFileGroup = new Group(parent, 0);
        this.configFileGroup.setText(CONFIGFILE);
        this.configFileGroup.setToolTipText(CONFIGFILE_TOOLTIP);
        GridData gd = new GridData(768);
        this.configFileGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.configFileGroup.setLayout((Layout)layout);
        this.configFileGroup.setFont(font);
        IProject project = this.getProject();
        this.configurationFileText = project == null ? new TITANResourceLocator(CONFIGFILE, (Composite)this.configFileGroup, 1, EMPTY) : new TITANResourceLocator(CONFIGFILE, (Composite)this.configFileGroup, 1, this.getProject().getLocation().toOSString());
        this.configurationFileText.getLabelControl((Composite)this.configFileGroup).setToolTipText(CONFIGFILE_TOOLTIP);
        this.configurationFileText.getTextControl((Composite)this.configFileGroup).addModifyListener((ModifyListener)this.generalListener);
        this.automaticExecuteSectionExecution = new Button((Composite)this.configFileGroup, 32);
        this.automaticExecuteSectionExecution.setText("Execute automatically");
        this.automaticExecuteSectionExecution.setToolTipText("Execute the `EXECUTE' section of the configuration file automatically when launched");
        this.automaticExecuteSectionExecution.setSelection(false);
        this.automaticExecuteSectionExecution.addSelectionListener((SelectionListener)this.generalListener);
        this.automaticExecuteSectionExecution.setEnabled(true);
    }

    protected final void handleProjectButtonSelected() {
        String projectName;
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project selection");
        dialog.setMessage("Select a project to constrain your search.");
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> availableProjects = new ArrayList<IProject>(projects.length);
        for (IProject project : projects) {
            try {
                if (!project.isAccessible() || !project.hasNature("org.eclipse.titan.designer.core.TITANNature")) continue;
                availableProjects.add(project);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        dialog.setElements((Object[])availableProjects.toArray(new IProject[availableProjects.size()]));
        if (dialog.open() == 0 && !(projectName = ((IProject)dialog.getFirstResult()).getName()).equals(this.projectNameText.getText())) {
            this.projectNameText.setText(projectName);
        }
    }

    public final IProject getProject() {
        if (this.projectNameText == null) {
            return null;
        }
        String projectName = this.projectNameText.getText();
        IProject projectWithTitanNature = DynamicLinkingHelper.getProject(projectName);
        if (projectWithTitanNature != null) {
            this.projectIsValid = true;
        }
        return projectWithTitanNature;
    }

    private void handleProjectNameModified() {
        IProject project = this.getProject();
        if (project == null) {
            this.projectIsValid = false;
            return;
        }
        this.projectIsValid = true;
        this.workingdirectoryText.setStringValue(BaseMainControllerTab.getRAWWorkingDirectoryForProject(project));
        String executable = BaseMainControllerTab.getExecutableForProject(project);
        if (executable != null) {
            this.executableFileText.setStringValue(executable);
        }
    }

    protected final void handleWorkingDirectoryModified() {
        if (!EMPTY.equals(this.workingdirectoryText.getStringValue())) {
            IProject project = this.getProject();
            URI uri = project == null ? URIUtil.toURI((String)this.workingdirectoryText.getStringValue()) : TITANPathUtilities.resolvePathURI((String)this.workingdirectoryText.getStringValue(), (String)this.getProject().getLocation().toOSString());
            File file = new File(uri);
            if (file.exists() && file.isDirectory()) {
                this.workingDirectoryIsValid = true;
                return;
            }
            this.workingDirectoryIsValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ExecutableCalculationHelper checkExecutable(ILaunchConfiguration configuration, IProject project, URI executableFileName) {
        Process proc;
        BufferedReader stderr;
        ArrayList<String> shellCommand;
        StringBuilder lastParam;
        String exename;
        MessageConsoleStream stream;
        ProcessBuilder pb;
        ExecutableCalculationHelper result;
        block25: {
            IProject actualProject;
            result = new ExecutableCalculationHelper();
            File file = new File(executableFileName);
            if (!file.exists() || !file.isFile()) {
                return result;
            }
            pb = new ProcessBuilder(new String[0]);
            Map<String, String> env = pb.environment();
            try {
                HashMap tempEnvironmentalVariables = (HashMap)configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
                EnvironmentHelper.resolveVariables(env, tempEnvironmentalVariables);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                result.executableFileIsValid = false;
            }
            if (project != null && (actualProject = DynamicLinkingHelper.getProject(project.getName())) != null) {
                EnvironmentHelper.setTitanPath(env);
                EnvironmentHelper.set_LICENSE_FILE_PATH(env);
                EnvironmentHelper.set_LD_LIBRARY_PATH(DynamicLinkingHelper.getProject(actualProject.getName()), env);
            }
            stream = TITANConsole.getConsole().newMessageStream();
            exename = PathConverter.convert((String)file.getPath(), (boolean)true, (MessageConsole)TITANDebugConsole.getConsole());
            lastParam = new StringBuilder(exename);
            lastParam.append(" -v");
            shellCommand = new ArrayList<String>(3);
            shellCommand.add("sh");
            shellCommand.add("-c");
            shellCommand.add(lastParam.toString());
            for (String c : shellCommand) {
                stream.print(c + ' ');
            }
            stream.println();
            pb.command(shellCommand);
            Pattern singlePattern = Pattern.compile("TTCN-3 Test Executor \\(single mode\\).*");
            result.executableIsForSingleMode = false;
            stderr = null;
            try {
                proc = pb.start();
                stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String line = stderr.readLine();
                while (line != null) {
                    if (singlePattern.matcher(line).matches()) {
                        result.executableIsForSingleMode = true;
                    }
                    line = stderr.readLine();
                }
                proc.waitFor();
                result.executableFileIsValid = true;
                IOUtils.closeQuietly((Closeable)stderr);
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                result.executableFileIsValid = false;
            }
            catch (InterruptedException e2) {
                ErrorReporter.logExceptionStackTrace((Exception)e2);
                result.executableFileIsValid = false;
                break block25;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(stderr);
            }
        }
        lastParam = new StringBuilder(exename);
        lastParam.append(" -l");
        shellCommand.set(shellCommand.size() - 1, lastParam.toString());
        for (String c : shellCommand) {
            stream.print(c + ' ');
        }
        stream.println();
        BufferedReader stdout = null;
        try {
            String line;
            proc = pb.start();
            stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            while ((line = stdout.readLine()) != null) {
                result.availableTestcases.add(line);
                stream.println(line);
            }
            int exitval = proc.waitFor();
            if (exitval != 0 && stderr.ready()) {
                stream.println("Testing of the executable failed");
                stream.println("  with value:" + exitval);
                stream.println("Sent the following error messages:");
                while ((line = stderr.readLine()) != null) {
                    stream.println(line);
                }
                result.executableIsExecutable = false;
            } else {
                result.executableIsExecutable = true;
            }
            result.executableFileIsValid = true;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            result.executableFileIsValid = false;
            IOUtils.closeQuietly((Closeable[])new Closeable[]{stdout, stderr});
        }
        catch (InterruptedException e3) {
            ErrorReporter.logExceptionStackTrace((Exception)e3);
            result.executableFileIsValid = false;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable[])new Closeable[]{stdout, stderr});
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable[])new Closeable[]{stdout, stderr});
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{stdout, stderr});
        return result;
    }

    protected final void handleExecutableModified() {
        if (EMPTY.equals(this.executableFileText.getStringValue())) {
            return;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                IProject project = BaseMainControllerTab.this.getProject();
                URI uri = project == null ? URIUtil.toURI((String)BaseMainControllerTab.this.executableFileText.getStringValue()) : TITANPathUtilities.resolvePathURI((String)BaseMainControllerTab.this.executableFileText.getStringValue(), (String)BaseMainControllerTab.this.getProject().getLocation().toOSString());
                ExecutableCalculationHelper helper = BaseMainControllerTab.checkExecutable((ILaunchConfiguration)BaseMainControllerTab.this.lastConfiguration, DynamicLinkingHelper.getProject(BaseMainControllerTab.this.projectNameText.getText()), uri);
                BaseMainControllerTab.this.executableFileIsValid = helper.executableFileIsValid;
                BaseMainControllerTab.this.executableIsExecutable = helper.executableIsExecutable;
                BaseMainControllerTab.this.executableIsForSingleMode = helper.executableIsForSingleMode;
                List<String> availableTestcases = helper.availableTestcases;
                ILaunchConfigurationTab[] tabs = BaseMainControllerTab.this.tabGroup.getTabs();
                TestSetTab testSetTab = null;
                for (ILaunchConfigurationTab tab : tabs) {
                    if (!(tab instanceof TestSetTab)) continue;
                    testSetTab = (TestSetTab)tab;
                }
                if (testSetTab != null) {
                    testSetTab.setAvailableTestcases(availableTestcases.toArray(new String[availableTestcases.size()]));
                }
            }
        });
    }

    protected final void handleConfigurationModified() {
        if (EMPTY.equals(this.configurationFileText.getStringValue())) {
            this.automaticExecuteSectionExecution.setEnabled(false);
            return;
        }
        IProject project = this.getProject();
        URI uri = project == null ? URIUtil.toURI((String)this.configurationFileText.getStringValue()) : TITANPathUtilities.resolvePathURI((String)this.configurationFileText.getStringValue(), (String)this.getProject().getLocation().toOSString());
        File file = new File(uri);
        if (file.exists() && file.isFile()) {
            this.exceptions.clear();
            ConfigFileHandler configHandler = new ConfigFileHandler();
            configHandler.readFromFile(file.getPath());
            if (configHandler.parseExceptions().isEmpty()) {
                HashMap<String, String> env = new HashMap<String, String>(System.getenv());
                try {
                    Map tempEnvironmentalVariables = this.lastConfiguration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
                    EnvironmentHelper.resolveVariables(env, tempEnvironmentalVariables);
                    configHandler.setEnvMap(env);
                    configHandler.processASTs();
                }
                catch (CoreException e) {
                    this.exceptions.add(e);
                    this.configurationFileIsValid = false;
                }
            }
            this.exceptions.addAll(configHandler.parseExceptions());
            if (this.exceptions.isEmpty()) {
                this.configurationFileIsValid = true;
                this.automaticExecuteSectionExecution.setEnabled(true);
                return;
            }
        }
        this.configurationFileIsValid = false;
        this.exceptions.clear();
        this.exceptions.add(new Exception("The path `" + URIUtil.toPath((URI)uri) + "' does not seem to be correct."));
        this.automaticExecuteSectionExecution.setEnabled(false);
    }

    public static String getRAWWorkingDirectoryForProject(IProject project) {
        try {
            String workingDirectory = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
            return workingDirectory;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return "bin";
        }
    }

    public static String getExecutableForProject(IProject project) {
        try {
            String executable = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            if (executable != null) {
                return executable;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return EMPTY;
    }

    public boolean canSave() {
        if (!EMPTY.equals(this.projectNameText.getText()) && !this.projectIsValid) {
            return false;
        }
        if (EMPTY.equals(this.workingdirectoryText.getStringValue()) || !this.workingDirectoryIsValid) {
            return false;
        }
        return super.canSave();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!EMPTY.equals(this.projectNameText.getText()) && !this.projectIsValid) {
            this.setErrorMessage("The name of the project is not valid.");
            return false;
        }
        if (EMPTY.equals(this.workingdirectoryText.getStringValue())) {
            this.setErrorMessage("The working directory must be set.");
            return false;
        }
        if (!this.workingDirectoryIsValid) {
            this.setErrorMessage("The working directory is not valid.");
            return false;
        }
        if (EMPTY.equals(this.configurationFileText.getStringValue())) {
            this.setErrorMessage("The configuration file must be set.");
            return false;
        }
        if (!this.configurationFileIsValid) {
            if (null != this.exceptions && !this.exceptions.isEmpty()) {
                this.setErrorMessage("Problem in config file: " + this.exceptions.get(0).getMessage());
            } else {
                this.setErrorMessage("The configuration file is not valid.");
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public static boolean initLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration, IProject project, String configFilePath, boolean singleMode) {
        ExecutableCalculationHelper helper;
        configuration.setAttribute("org.eclipse.titan.executor.projectName", project.getName());
        String workingDirectory = BaseMainControllerTab.getRAWWorkingDirectoryForProject(project);
        if (StringUtils.isNullOrEmpty((String)workingDirectory)) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The working directory must be set.");
            return false;
        }
        URI uri = TITANPathUtilities.resolvePathURI((String)workingDirectory, (String)project.getLocation().toOSString());
        File file = new File(uri);
        if (!file.exists()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The working directory does not exist.");
            return false;
        }
        if (!file.isDirectory()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The path set as working directory does not point to a folder.");
            return false;
        }
        configuration.setAttribute("org.eclipse.titan.executor.workingdirectoryPath", workingDirectory);
        String executable = BaseMainControllerTab.getExecutableForProject(project);
        URI uri2 = TITANPathUtilities.resolvePathURI((String)executable, (String)project.getLocation().toOSString());
        if (null != executable && executable.length() > 0) {
            file = new File(uri2);
            helper = BaseMainControllerTab.checkExecutable((ILaunchConfiguration)configuration, project, uri2);
            if (!file.exists()) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The executable file does not exist.");
                return false;
            }
            if (file.isDirectory()) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The file set as the executable is a folder.");
                return false;
            }
            if (!helper.executableFileIsValid) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The executable file is not valid.");
                return false;
            }
        } else {
            helper = new ExecutableCalculationHelper();
        }
        if (!helper.executableIsExecutable) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The executable is not actually executable. Please set an executable generated for parallel mode execution as the executable.");
            return false;
        }
        if (singleMode) {
            if (!helper.executableIsForSingleMode) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The executable was built for parallel mode execution, it can not be launched using a single mode launcher.");
                return false;
            }
        } else if (helper.executableIsForSingleMode) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The executable was built for single mode execution, it can not be launched in a parallel mode launcher.");
            return false;
        }
        configuration.setAttribute("org.eclipse.titan.executor.executableFilePath", executable);
        TestSetTab.setTestcases(configuration, helper.availableTestcases.toArray(new String[helper.availableTestcases.size()]));
        if (!EMPTY.equals(configFilePath)) {
            URI uri3 = TITANPathUtilities.resolvePathURI((String)configFilePath, (String)project.getLocation().toOSString());
            file = new File(uri3);
            if (!file.exists()) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The configurationfile does not exist.");
            }
            if (!file.isFile()) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)("An error was found while creating the default launch configuration for project " + project.getName()), (String)"The file set as the configuration file is a folder.");
            }
        }
        configuration.setAttribute("org.eclipse.titan.executor.configurationFilePath", configFilePath);
        configuration.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", !EMPTY.equals(configFilePath));
        return true;
    }

    public static final class ExecutableCalculationHelper {
        public boolean executableFileIsValid = false;
        public boolean executableIsExecutable = false;
        public boolean executableIsForSingleMode = false;
        public List<String> availableTestcases = new ArrayList<String>();
    }

    private final class BasicProjectSelectorListener
    extends SelectionAdapter
    implements ModifyListener {
        private BasicProjectSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (null == source) {
                return;
            }
            if (source.equals(BaseMainControllerTab.this.projectNameText)) {
                BaseMainControllerTab.this.handleProjectNameModified();
            } else if (source.equals(BaseMainControllerTab.this.workingdirectoryText.getTextControl((Composite)BaseMainControllerTab.this.workingDirGroup))) {
                BaseMainControllerTab.this.handleWorkingDirectoryModified();
            } else if (source.equals(BaseMainControllerTab.this.executableFileText.getTextControl((Composite)BaseMainControllerTab.this.executableGroup))) {
                BaseMainControllerTab.this.handleExecutableModified();
            } else if (source.equals(BaseMainControllerTab.this.configurationFileText.getTextControl((Composite)BaseMainControllerTab.this.configFileGroup))) {
                BaseMainControllerTab.this.handleConfigurationModified();
            }
            BaseMainControllerTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (null == source) {
                return;
            }
            if (source.equals(BaseMainControllerTab.this.projectSelectionButton)) {
                BaseMainControllerTab.this.handleProjectButtonSelected();
            }
            BaseMainControllerTab.this.updateLaunchConfigurationDialog();
        }
    }
}

