/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.testset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeLeaf;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.tabpages.testset.KnownTestcasesDragSourceListener;
import org.eclipse.titan.executor.tabpages.testset.TestCaseTreeElement;
import org.eclipse.titan.executor.tabpages.testset.TestcaseTransfer;
import org.eclipse.titan.executor.tabpages.testset.TestcasesContentProvider;
import org.eclipse.titan.executor.tabpages.testset.TestcasesLabelProvider;
import org.eclipse.titan.executor.tabpages.testset.TestsetDialog;
import org.eclipse.titan.executor.tabpages.testset.TestsetTreeDragSourceListener;
import org.eclipse.titan.executor.tabpages.testset.TestsetTreeDropTargetListener;
import org.eclipse.titan.executor.tabpages.testset.TestsetTreeElement;

public final class TestSetTab
extends AbstractLaunchConfigurationTab {
    public static final String AVAILABLETESTCASES_LABEL = "availableTestcases";
    public static final String AVAILABLECONTROLPARTS_LABEL = "availableControlParts";
    public static final String TESTSETNAMES_LABEL = "testsetNames";
    public static final String TESTCASESOF_PREFIX = "testcasesOf";
    private static final String TESTCASELIST_CHANGED = "The list of available testcases seems to have changed, please visit the Testsets page";
    private static final String CONTROLPARTLIST_CHANGED = "The list of available control parts seems to have changed, please visit the Testsets page";
    private TableViewer knownTestcasesViewer;
    private TestcasesLabelProvider testcasesLabelProvider;
    private TestsetTreeElement tableRoot;
    private TreeViewer testsetViewer;
    private TestsetTreeElement treeRoot;
    private Composite mainComposite;
    private List<String> availableTestcases;
    private List<String> availableControlparts;
    private MenuManager manager;
    private Action newTestset;
    private Action remove;
    private Action rename;

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.setControl((Control)this.mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)gridData);
        this.mainComposite.setFont(parent.getFont());
        this.testcasesLabelProvider = new TestcasesLabelProvider();
        this.createKnownTestCasesViewer(this.mainComposite);
        this.createTestsetViewer(this.mainComposite);
        this.createActions();
        this.manager = new MenuManager("menuManager");
        this.createContextMenu();
        Dialog.applyDialogFont((Control)this.mainComposite);
    }

    private void createKnownTestCasesViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText("testcases:");
        this.knownTestcasesViewer = new TableViewer(composite, 68354);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        this.knownTestcasesViewer.getControl().setLayoutData((Object)data);
        this.knownTestcasesViewer.setContentProvider((IContentProvider)new TestcasesContentProvider());
        this.knownTestcasesViewer.setLabelProvider((IBaseLabelProvider)this.testcasesLabelProvider);
        int ops = 1;
        Transfer[] types = new Transfer[]{TestcaseTransfer.getInstance()};
        this.knownTestcasesViewer.addDragSupport(ops, types, (DragSourceListener)new KnownTestcasesDragSourceListener(this.knownTestcasesViewer));
        this.tableRoot = new TestsetTreeElement("tableRoot");
        this.knownTestcasesViewer.setInput((Object)this.tableRoot);
        label = new Label(composite, 0);
        label.setText("As extracted from the executable.\nRefreshed when the Executable on the MainController page changes.");
    }

    public void setAvailableTestcases(String[] testcases) {
        this.tableRoot.dispose();
        this.tableRoot = new TestsetTreeElement("tableRoot");
        this.availableControlparts = new ArrayList<String>();
        this.availableTestcases = new ArrayList<String>();
        for (String testcase : testcases) {
            String testcaseName = testcase;
            if (testcaseName.endsWith(".control")) {
                this.availableControlparts.add(testcaseName);
                this.tableRoot.addChildToEnd(new TestCaseTreeElement(testcaseName));
                continue;
            }
            this.availableTestcases.add(testcaseName);
            this.tableRoot.addChildToEnd(new TestCaseTreeElement(testcaseName));
        }
        this.testcasesLabelProvider.addTestcases(this.availableTestcases);
        this.testcasesLabelProvider.addControlParts(this.availableControlparts);
        this.knownTestcasesViewer.setInput((Object)this.tableRoot);
        this.mainComposite.layout(true);
        this.testsetViewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    private void createTestsetViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText("test sets:");
        this.testsetViewer = new TreeViewer(composite, 2818);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.testsetViewer.getControl().setLayoutData((Object)data);
        this.testsetViewer.setContentProvider((IContentProvider)new TestcasesContentProvider());
        this.testsetViewer.setLabelProvider((IBaseLabelProvider)this.testcasesLabelProvider);
        int dragOps = 3;
        Transfer[] types = new Transfer[]{TestcaseTransfer.getInstance()};
        this.testsetViewer.addDragSupport(dragOps, types, (DragSourceListener)new TestsetTreeDragSourceListener(this.testsetViewer));
        int dropOps = 19;
        this.testsetViewer.addDropSupport(dropOps, types, (DropTargetListener)new TestsetTreeDropTargetListener(this.testsetViewer, this));
        this.testsetViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TestSetTab.this.remove.setEnabled(!selection.isEmpty());
                TestSetTab.this.rename.setEnabled(!selection.isEmpty() && selection.getFirstElement() instanceof TestsetTreeElement);
            }
        });
        this.treeRoot = new TestsetTreeElement("treeRoot");
        this.testsetViewer.setInput((Object)this.treeRoot);
        label = new Label(composite, 0);
        label.setText("Right click to add or remove testsets.\nUse drag&drop to add,remove or reorder testcases.");
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }

    private void createActions() {
        this.newTestset = new Action("create new testset"){

            public void run() {
                if (null == TestSetTab.this.testsetViewer) {
                    return;
                }
                TestsetDialog dialog = new TestsetDialog(TestSetTab.this.getShell(), "Create new testset");
                if (dialog.open() != 0) {
                    return;
                }
                String testsetName = dialog.getTestsetName();
                List<ITreeLeaf> children = TestSetTab.this.treeRoot.children();
                for (ITreeLeaf aChildren : children) {
                    if (!aChildren.name().equals(testsetName)) continue;
                    return;
                }
                TestSetTab.this.treeRoot.addChildToEnd(new TestsetTreeElement(testsetName));
                TestSetTab.this.testsetViewer.refresh();
                TestSetTab.this.updateLaunchConfigurationDialog();
                super.run();
            }
        };
        this.newTestset.setToolTipText("creates a new testset");
        this.newTestset.setEnabled(true);
        this.rename = new Action("rename testset"){

            public void run() {
                if (null == TestSetTab.this.testsetViewer || TestSetTab.this.testsetViewer.getSelection().isEmpty()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)TestSetTab.this.testsetViewer.getSelection();
                TestsetDialog dialog = new TestsetDialog(TestSetTab.this.getShell(), "Rename testset");
                dialog.setTestsetName(((TestsetTreeElement)selection.getFirstElement()).name());
                if (dialog.open() != 0) {
                    return;
                }
                String testsetName = dialog.getTestsetName();
                List<ITreeLeaf> children = TestSetTab.this.treeRoot.children();
                for (ITreeLeaf aChildren : children) {
                    if (!aChildren.name().equals(testsetName)) continue;
                    return;
                }
                ((TestsetTreeElement)selection.getFirstElement()).name(testsetName);
                TestSetTab.this.testsetViewer.refresh();
                TestSetTab.this.updateLaunchConfigurationDialog();
                super.run();
            }
        };
        this.rename.setToolTipText("rename selected testset");
        this.rename.setEnabled(false);
        this.remove = new Action("remove"){

            public void run() {
                if (null == TestSetTab.this.testsetViewer || TestSetTab.this.testsetViewer.getSelection().isEmpty()) {
                    return;
                }
                TestSetTab.this.testsetViewer.getTree().setRedraw(false);
                IStructuredSelection selection = (IStructuredSelection)TestSetTab.this.testsetViewer.getSelection();
                for (TreeLeaf element : selection) {
                    if (null == element.parent()) continue;
                    ((TestsetTreeElement)element.parent()).remove(element);
                    element.dispose();
                }
                TestSetTab.this.testsetViewer.getTree().setRedraw(true);
                TestSetTab.this.testsetViewer.refresh();
                TestSetTab.this.updateLaunchConfigurationDialog();
                super.run();
            }
        };
        this.remove.setToolTipText("removes the selected elements");
        this.remove.setEnabled(false);
    }

    private void createContextMenu() {
        this.manager.removeAll();
        this.manager.add((IAction)this.newTestset);
        this.manager.add((IAction)this.rename);
        this.manager.add((IAction)this.remove);
        Menu menu = this.manager.createContextMenu(this.testsetViewer.getControl());
        this.testsetViewer.getControl().setMenu(menu);
    }

    public String getName() {
        return "Testsets";
    }

    public Image getImage() {
        return ImageCache.getImage("testset.gif");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.treeRoot.dispose();
        this.treeRoot = new TestsetTreeElement("treeroot");
        try {
            List testsetNames = configuration.getAttribute(TESTSETNAMES_LABEL, (List)null);
            if (null != testsetNames) {
                Iterator iterator = testsetNames.iterator();
                while (iterator.hasNext()) {
                    String testsetName1;
                    String testsetName = testsetName1 = (String)iterator.next();
                    TestsetTreeElement helperTestset = new TestsetTreeElement(testsetName);
                    this.treeRoot.addChildToEnd(helperTestset);
                    List testCases = configuration.getAttribute(TESTCASESOF_PREFIX + testsetName, (List)null);
                    for (String testCase : testCases) {
                        TestCaseTreeElement helperTestcase = new TestCaseTreeElement(testCase);
                        helperTestset.addChildToEnd(helperTestcase);
                    }
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.testsetViewer.setInput((Object)this.treeRoot);
        try {
            List tempAvailableTestcases = configuration.getAttribute(AVAILABLETESTCASES_LABEL, (List)null);
            List tempAvailableControlParts = configuration.getAttribute(AVAILABLECONTROLPARTS_LABEL, (List)null);
            if (tempAvailableTestcases != null && !tempAvailableTestcases.equals(this.availableTestcases)) {
                this.setErrorMessage(TESTCASELIST_CHANGED);
            }
            if (tempAvailableControlParts != null && !tempAvailableControlParts.equals(this.availableControlparts)) {
                this.setErrorMessage(CONTROLPARTLIST_CHANGED);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        ArrayList<String> testsetNames = new ArrayList<String>();
        ArrayList testSets = new ArrayList();
        for (ITreeLeaf testSet : this.treeRoot.children()) {
            testsetNames.add(testSet.name());
            ArrayList<String> testcases = new ArrayList<String>();
            for (ITreeLeaf testcase : ((TestsetTreeElement)testSet).children()) {
                testcases.add(testcase.name());
            }
            testSets.add(testcases);
        }
        configuration.setAttribute(AVAILABLECONTROLPARTS_LABEL, this.availableControlparts);
        configuration.setAttribute(AVAILABLETESTCASES_LABEL, this.availableTestcases);
        configuration.setAttribute(TESTSETNAMES_LABEL, testsetNames);
        int size = testSets.size();
        for (int i = 0; i < size; ++i) {
            configuration.setAttribute(TESTCASESOF_PREFIX + (String)testsetNames.get(i), (List)testSets.get(i));
        }
        this.setErrorMessage(null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
        this.updateLaunchConfigurationDialog();
    }

    public static void setTestcases(ILaunchConfigurationWorkingCopy workingCopy, String[] testcases) {
        ArrayList<String> availableControlparts = new ArrayList<String>();
        ArrayList<String> availableTestcases = new ArrayList<String>();
        for (String testcase : testcases) {
            String testcaseName = testcase;
            if (testcaseName.endsWith(".control")) {
                availableControlparts.add(testcaseName);
                continue;
            }
            availableTestcases.add(testcaseName);
        }
        workingCopy.setAttribute(AVAILABLECONTROLPARTS_LABEL, availableControlparts);
        workingCopy.setAttribute(AVAILABLETESTCASES_LABEL, availableTestcases);
    }
}

