/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench.forms;

import java.lang.reflect.Method;
import org.eclipse.mylyn.internal.commons.workbench.CommonsWorkbenchPlugin;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class CommonFormUtil {
    public static FormColors getSharedColors() {
        return CommonsWorkbenchPlugin.getDefault().getFormColors(Display.getDefault());
    }

    public static void disableScrollingOnFocus(ScrolledForm form) {
        form.setData("focusScrolling", (Object)Boolean.FALSE);
    }

    public static void ensureVisible(Control control) {
        ScrolledComposite form = FormUtil.getScrolledComposite((Control)control);
        if (form != null) {
            if (control instanceof StyledText) {
                Point origin = FormUtil.getControlLocation((ScrolledComposite)form, (Control)control);
                Point caretLocation = ((StyledText)control).getCaret().getLocation();
                origin.x += caretLocation.x;
                origin.y += caretLocation.y;
                FormUtil.ensureVisible((ScrolledComposite)form, (Point)origin, (Point)new Point(20, 20));
            } else {
                FormUtil.ensureVisible((ScrolledComposite)form, (Control)control);
            }
        }
    }

    public static void setExpanded(ExpandableComposite comp, boolean expanded) {
        if (comp.isExpanded() != expanded) {
            Method method = null;
            try {
                method = ExpandableComposite.class.getDeclaredMethod("programmaticToggleState", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)comp, new Object[0]);
            }
            catch (Exception exception) {}
        }
    }
}

