/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VText;
import java.awt.geom.Point2D;
import net.claribole.zgrviewer.BroughtElement;
import net.claribole.zgrviewer.LEdge;

class BroughtEdge
extends BroughtElement {
    DPath spline;
    float splineAlpha;
    Point2D.Double[] splineCoords;

    BroughtEdge(LEdge e) {
        this.glyphs = e.getGlyphs();
        this.spline = e.getSpline();
        if (this.spline != null) {
            this.splineCoords = this.spline.getAllPointsCoordinates();
            this.splineAlpha = this.spline.getTranslucencyValue();
        }
        this.previousLocations = new Point2D.Double[this.glyphs.length];
        for (int i = 0; i < this.glyphs.length; ++i) {
            this.previousLocations[i] = this.glyphs[i] == this.spline ? null : (this.glyphs[i] instanceof VText ? this.glyphs[i].getLocation() : null);
        }
    }

    Point2D.Double restorePreviousState(int duration, Glyph g) {
        Animation a = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createPathAnim(duration, this.spline, this.splineCoords, false, SlowInSlowOutInterpolator.getInstance(), null);
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(a, true);
        this.spline.setTranslucencyValue(this.splineAlpha);
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!this.glyphs[i].isVisible()) {
                this.glyphs[i].setVisible(true);
            }
            if (this.previousLocations[i] == null) continue;
            a = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createGlyphTranslation(duration, this.glyphs[i], this.previousLocations[i], false, SlowInSlowOutInterpolator.getInstance(), null);
            VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(a, true);
        }
        return null;
    }
}

