/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.preferences.pages;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.Activator;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TITANCommonPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "TITAN Common Preferences";
    private Group mergeGroup;
    private RadioGroupFieldEditor mergeOptions;

    public TITANCommonPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
        super.initialize();
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.mergeGroup = new Group(parent, 64);
        this.mergeGroup.setText("Log file merge");
        this.mergeGroup.setLayout((Layout)new GridLayout(1, false));
        this.mergeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        String[][] labelAndValues = new String[][]{{"Overwrite file", "overwrite"}, {"Create a new file", "create"}, {"Ask", "ask"}};
        this.mergeOptions = new RadioGroupFieldEditor("org.eclipse.titan.common.automaticMergeOptions", "If the merged file already exists:", 1, labelAndValues, (Composite)this.mergeGroup, true);
        this.addField((FieldEditor)this.mergeOptions);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IEclipsePreferences preferences = Platform.getPreferencesService().getRootNode();
        IEclipsePreferences node = (IEclipsePreferences)preferences.node("instance").node("org.eclipse.titan.common");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace("Error while saving the preferences", e);
            }
        }
        return result;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.mergeOptions.dispose();
        this.mergeGroup.dispose();
        super.dispose();
    }
}

