/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.classrealm.ClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmManagerDelegate;
import org.apache.maven.classrealm.ClassRealmRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class EclipseClassRealmManagerDelegate
implements ClassRealmManagerDelegate {
    public static final String ROLE_HINT = EclipseClassRealmManagerDelegate.class.getName();
    private static final String PLEXUSBUILDCONTEXT_PROPERTIES = "/org/sonatype/plexus/build/incremental/version.properties";
    private final PlexusContainer plexus;
    private static final ArtifactVersion currentBuildApiVersion;

    static {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream is = EclipseClassRealmManagerDelegate.class.getResourceAsStream(PLEXUSBUILDCONTEXT_PROPERTIES);){
                if (is != null) {
                    props.load(is);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        currentBuildApiVersion = new DefaultArtifactVersion(props.getProperty("api.version", "0.0.5"));
    }

    @Inject
    public EclipseClassRealmManagerDelegate(PlexusContainer plexus) {
        this.plexus = plexus;
    }

    public void setupRealm(ClassRealm realm, ClassRealmRequest request) {
        if (this.supportsBuildApi(request.getConstituents())) {
            ClassRealm coreRealm = this.plexus.getContainerRealm();
            realm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.DirectoryScanner");
            realm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.AbstractScanner");
            realm.importFrom((ClassLoader)coreRealm, "org.codehaus.plexus.util.Scanner");
            realm.importFrom((ClassLoader)coreRealm, "org.sonatype.plexus.build.incremental");
        }
    }

    private boolean supportsBuildApi(List<ClassRealmConstituent> constituents) {
        Iterator<ClassRealmConstituent> it = constituents.iterator();
        while (it.hasNext()) {
            boolean compatible;
            ClassRealmConstituent constituent = it.next();
            if (!"org.sonatype.plexus".equals(constituent.getGroupId()) || !"plexus-build-api".equals(constituent.getArtifactId())) continue;
            DefaultArtifactVersion version = new DefaultArtifactVersion(constituent.getVersion());
            boolean bl = compatible = currentBuildApiVersion.compareTo((Object)version) >= 0;
            if (compatible) {
                it.remove();
            }
            return compatible;
        }
        return false;
    }
}

