/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine.portals;

import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.event.PortalListener;
import java.awt.Dimension;
import java.awt.Graphics2D;

public abstract class Portal {
    public int x;
    public int y;
    public int w;
    public int h;
    Dimension size = new Dimension(0, 0);
    View owningView;
    PortalListener pevH;
    public boolean cursorInside = false;
    boolean visible = true;

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void resize(int dw, int dh) {
        this.w += dw;
        this.h += dh;
        this.updateDimensions();
    }

    public void sizeTo(int w, int h) {
        this.w = w;
        this.h = h;
        this.updateDimensions();
    }

    public Dimension getDimensions() {
        return new Dimension(this.w, this.h);
    }

    public void updateDimensions() {
        this.size.setSize(this.w, this.h);
    }

    public void setOwningView(View v) {
        this.owningView = v;
    }

    public View getOwningView() {
        return this.owningView;
    }

    public void setPortalListener(PortalListener peh) {
        this.pevH = peh;
    }

    public PortalListener getPortalListener() {
        return this.pevH;
    }

    public abstract boolean coordInside(int var1, int var2);

    public int cursorInOut(int cx, int cy) {
        if (!this.visible) {
            return 0;
        }
        if (this.coordInside(cx, cy)) {
            if (!this.cursorInside) {
                this.cursorInside = true;
                if (this.pevH != null) {
                    this.pevH.enterPortal(this);
                }
                return 1;
            }
            return 0;
        }
        if (this.cursorInside) {
            this.cursorInside = false;
            if (this.pevH != null) {
                this.pevH.exitPortal(this);
            }
            return -1;
        }
        return 0;
    }

    public int[] getDistanceFromBorders(int cx, int cy, int[] res) {
        res[0] = cx - this.x;
        res[1] = cy - this.y;
        res[2] = this.x + this.w - cx;
        res[3] = this.y + this.h - cy;
        return res;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public abstract void paint(Graphics2D var1, int var2, int var3);
}

