/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.projection.RProjectedCoords;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIRectangle<T>
extends ClosedShape
implements RectangularShape {
    double vw;
    double vh;
    double ar;
    RProjectedCoords[] pc;

    public SIRectangle() {
        this(0.0, 0.0, 0, 5.0, 5.0, Color.WHITE, Color.BLACK);
    }

    public SIRectangle(double x, double y, int z, double w, double h, Color c) {
        this(x, y, z, w, h, c, Color.BLACK);
    }

    public SIRectangle(double x, double y, int z, double w, double h, Color c, Color bc) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = w;
        this.vh = h;
        this.computeSize();
        this.ar = this.vw == 0.0 && this.vh == 0.0 ? 1.0 : this.vw / this.vh;
        this.orient = 0.0;
        this.setColor(c);
        this.setBorderColor(bc);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new RProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new RProjectedCoords();
            this.pc[i].cw = (int)(this.vw / 2.0);
            this.pc[i].ch = (int)(this.vh / 2.0);
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                RProjectedCoords[] ta = this.pc;
                this.pc = new RProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new RProjectedCoords();
                this.pc[this.pc.length - 1].cw = (int)(this.vw / 2.0);
                this.pc[this.pc.length - 1].ch = (int)(this.vh / 2.0);
            } else {
                System.err.println("SIRectangle:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new RProjectedCoords[1];
            this.pc[0] = new RProjectedCoords();
            this.pc[0].cw = (int)(this.vw / 2.0);
            this.pc[0].ch = (int)(this.vh / 2.0);
        } else {
            System.err.println("SIRectangle:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return 0.0;
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public double getWidth() {
        return this.vw;
    }

    @Override
    public double getHeight() {
        return this.vh;
    }

    void computeSize() {
        this.size = Math.sqrt(this.vw * this.vw + this.vh * this.vh);
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        this.updateProjectedWH();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setWidth(double w) {
        this.vw = w;
        this.computeSize();
        this.updateProjectedWH();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setHeight(double h) {
        this.vh = h;
        this.computeSize();
        this.updateProjectedWH();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        this.updateProjectedWH();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.vw / 2.0, this.vy + this.vh / 2.0, this.vx + this.vw / 2.0, this.vy - this.vh / 2.0};
        return res;
    }

    private void updateProjectedWH() {
        if (this.pc != null) {
            for (int i = 0; i < this.pc.length; ++i) {
                try {
                    this.pc[i].cw = (int)(this.vw / 2.0);
                    this.pc[i].ch = (int)(this.vh / 2.0);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - (double)this.pc[i].cw <= eb && this.vx + (double)this.pc[i].cw >= wb && this.vy - (double)this.pc[i].ch <= nb && this.vy + (double)this.pc[i].ch >= sb;
    }

    @Override
    public boolean containedInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return this.vx + (double)this.pc[i].cw <= eb && this.vx - (double)this.pc[i].cw >= wb && this.vy + (double)this.pc[i].ch <= nb && this.vy - (double)this.pc[i].ch >= sb;
        }
        return false;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return w <= (double)(this.pc[camIndex].cx + this.pc[camIndex].cw) && 0 >= this.pc[camIndex].cx - this.pc[camIndex].cw && h <= (double)(this.pc[camIndex].cy + this.pc[camIndex].ch) && 0 >= this.pc[camIndex].cy - this.pc[camIndex].ch;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return dvs.intersects(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return jpx >= this.pc[camIndex].cx - this.pc[camIndex].cw && jpx <= this.pc[camIndex].cx + this.pc[camIndex].cw && jpy >= this.pc[camIndex].cy - this.pc[camIndex].ch && jpy <= this.pc[camIndex].cy + this.pc[camIndex].ch;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                }
            }
        } else if (this.pc[i].cw <= 1 ^ this.pc[i].ch <= 1) {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.pc[i].cw <= 1) {
                    g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy - this.pc[i].ch, 1, 2 * this.pc[i].ch);
                } else if (this.pc[i].ch <= 1) {
                    g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy, 2 * this.pc[i].cw, 1);
                }
                g.setComposite(acO);
            } else if (this.pc[i].cw <= 1) {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy - this.pc[i].ch, 1, 2 * this.pc[i].ch);
            } else if (this.pc[i].ch <= 1) {
                g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy, 2 * this.pc[i].cw, 1);
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            g.setComposite(acO);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcw > 1 && this.pc[i].lch > 1) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                }
            }
        } else if (this.pc[i].lcw <= 1 ^ this.pc[i].lch <= 1) {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.pc[i].lcw <= 1) {
                    g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy - this.pc[i].lch, 1, 2 * this.pc[i].lch);
                } else if (this.pc[i].lch <= 1) {
                    g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy, 2 * this.pc[i].lcw, 1);
                }
                g.setComposite(acO);
            } else if (this.pc[i].lcw <= 1) {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy - this.pc[i].lch, 1, 2 * this.pc[i].lch);
            } else if (this.pc[i].lch <= 1) {
                g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy, 2 * this.pc[i].lcw, 1);
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            g.setComposite(acO);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Shape getJava2DShape() {
        return new Rectangle2D.Double(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public Object clone() {
        SIRectangle<T> res = new SIRectangle<T>(this.vx, this.vy, this.vz, this.vw, this.vh, this.color);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        res.setTranslucencyValue(this.getTranslucencyValue());
        return res;
    }
}

