/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CommitSelectDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithPreviousActionHandler
extends RepositoryActionHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        final IResource[] resources = this.getSelectedResources(event);
        if (resources.length != 1) {
            return null;
        }
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
                    RepositoryActionHandler.PreviousCommit previous = CompareWithPreviousActionHandler.this.getPreviousRevision(event, resources[0]);
                    if (previous != null) {
                        CompareUtils.compare(resources, repository, "HEAD", previous.commit.getName(), true, workBenchPage);
                    }
                }
                catch (Exception e) {
                    Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    @Override
    public boolean isEnabled() {
        IResource[] selectedResources = this.getSelectedResources();
        return super.isEnabled() && selectedResources.length == 1 && this.selectionMapsToSingleRepository();
    }

    private RepositoryActionHandler.PreviousCommit getPreviousRevision(final ExecutionEvent event, IResource resource) throws IOException {
        final List<RepositoryActionHandler.PreviousCommit> previousList = this.findPreviousCommits();
        final AtomicReference<RepositoryActionHandler.PreviousCommit> previous = new AtomicReference<RepositoryActionHandler.PreviousCommit>();
        if (previousList.size() == 0) {
            this.showNotFoundDialog(event, resource);
        } else if (previousList.size() == 1) {
            previous.set(previousList.get(0));
        } else {
            final ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (RepositoryActionHandler.PreviousCommit pc : previousList) {
                commits.add(pc.commit);
            }
            HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CommitSelectDialog dlg = new CommitSelectDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), commits);
                    if (dlg.open() == 0) {
                        for (RepositoryActionHandler.PreviousCommit pc : previousList) {
                            if (!pc.commit.equals((AnyObjectId)dlg.getSelectedCommit())) continue;
                            previous.set(pc);
                            break;
                        }
                    }
                }
            });
        }
        return (RepositoryActionHandler.PreviousCommit)previous.get();
    }

    private void showNotFoundDialog(final ExecutionEvent event, IResource resource) {
        final String message = MessageFormat.format(UIText.CompareWithPreviousActionHandler_MessageRevisionNotFound, resource.getName());
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)UIText.CompareWithPreviousActionHandler_TitleRevisionNotFound, (String)message);
            }
        });
    }
}

