/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitUI;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesTree;
import org.eclipse.egit.ui.internal.stash.StashCreateUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CleanupUncomittedChangesDialog
extends MessageDialog {
    private static final Image INFO = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private final Repository repository;
    private List<String> fileList;
    private boolean shouldContinue = false;

    public CleanupUncomittedChangesDialog(Shell shell, String dialogTitle, String dialogMessage, Repository repository, List<String> fileList) {
        super(shell, dialogTitle, INFO, dialogMessage, 2, new String[0], -1);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.fileList = fileList;
    }

    protected Control createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        new NonDeletedFilesTree(main, this.repository, this.fileList);
        CleanupUncomittedChangesDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 10: {
                CommitUI commitUI = new CommitUI(this.getShell(), this.repository, new IResource[0], true);
                this.shouldContinue = commitUI.commit();
                break;
            }
            case 7: {
                ResetOperation operation = new ResetOperation(this.repository, "HEAD", ResetCommand.ResetType.HARD);
                String jobname = NLS.bind((String)UIText.ResetAction_reset, (Object)"HEAD");
                JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)jobname, (Object)JobFamilies.RESET);
                this.shouldContinue = true;
                break;
            }
            case 5: {
                StashCreateUI stashCreateUI = new StashCreateUI(this.repository);
                this.shouldContinue = stashCreateUI.createStash(this.getShell());
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 10, UIText.BranchResultDialog_buttonCommit, false);
        this.createButton(parent, 5, UIText.BranchResultDialog_buttonStash, false);
        this.createButton(parent, 7, UIText.BranchResultDialog_buttonReset, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public boolean shouldContinue() {
        return this.shouldContinue;
    }
}

