/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.WorkingTreeFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.revision.LocalFileRevision;
import org.eclipse.egit.ui.internal.revision.LocationEditableRevision;
import org.eclipse.egit.ui.internal.revision.ResourceEditableRevision;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.PlatformUI;

public class GitMergeEditorInput
extends CompareEditorInput {
    private static final String LABELPATTERN = "{0} - {1}";
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image PROJECT_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    private final boolean useWorkspace;
    private final IPath[] locations;

    public GitMergeEditorInput(boolean useWorkspace, IPath ... locations) {
        super(new CompareConfiguration());
        this.useWorkspace = useWorkspace;
        this.locations = locations;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setLeftEditable(true);
    }

    public Object getAdapter(Class adapter) {
        DiffNode diffNode;
        ITypedElement element;
        Object selectedEdition;
        if ((adapter == IFile.class || adapter == IResource.class) && GitMergeEditorInput.isUIThread() && (selectedEdition = this.getSelectedEdition()) instanceof DiffNode && (element = (diffNode = (DiffNode)selectedEdition).getLeft()) instanceof ResourceEditableRevision) {
            ResourceEditableRevision resourceRevision = (ResourceEditableRevision)element;
            return resourceRevision.getFile();
        }
        return super.getAdapter(adapter);
    }

    private static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RevWalk rw = null;
        try {
            RevCommit ancestorCommit;
            String fullBranch;
            RevCommit headCommit;
            RevCommit rightCommit;
            monitor.beginTask(UIText.GitMergeEditorInput_CheckingResourcesTaskName, -1);
            Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(this.locations));
            if (pathsByRepository.size() != 1) {
                throw new InvocationTargetException(new IllegalStateException(UIText.RepositoryAction_multiRepoSelection));
            }
            Repository repo = (Repository)pathsByRepository.keySet().iterator().next();
            ArrayList<String> filterPaths = new ArrayList<String>((Collection)pathsByRepository.get(repo));
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            rw = new RevWalk(repo);
            try {
                String target = repo.getRepositoryState().equals((Object)RepositoryState.MERGING) ? "MERGE_HEAD" : (repo.getRepositoryState().equals((Object)RepositoryState.CHERRY_PICKING) ? "CHERRY_PICK_HEAD" : (repo.getRepositoryState().equals((Object)RepositoryState.REBASING_INTERACTIVE) ? this.readFile(repo.getDirectory(), "rebase-merge" + File.separatorChar + "stopped-sha") : "ORIG_HEAD"));
                ObjectId mergeHead = repo.resolve(target);
                if (mergeHead == null) {
                    throw new IOException(NLS.bind((String)UIText.ValidationUtils_CanNotResolveRefMessage, (Object)target));
                }
                rightCommit = rw.parseCommit((AnyObjectId)mergeHead);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                ObjectId head = repo.resolve("HEAD");
                if (head == null) {
                    throw new IOException(NLS.bind((String)UIText.ValidationUtils_CanNotResolveRefMessage, (Object)"HEAD"));
                }
                headCommit = rw.parseCommit((AnyObjectId)head);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                fullBranch = repo.getFullBranch();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            ArrayList<RevCommit> startPoints = new ArrayList<RevCommit>();
            rw.setRevFilter(RevFilter.MERGE_BASE);
            startPoints.add(rightCommit);
            startPoints.add(headCommit);
            try {
                rw.markStart(startPoints);
                ancestorCommit = rw.next();
            }
            catch (Exception e) {
                ancestorCommit = null;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            CompareConfiguration config = this.getCompareConfiguration();
            config.setRightLabel(NLS.bind((String)LABELPATTERN, (Object)rightCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(rightCommit.name())));
            if (!this.useWorkspace) {
                config.setLeftLabel(NLS.bind((String)LABELPATTERN, (Object)headCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(headCommit.name())));
            } else {
                config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceHeader);
            }
            if (ancestorCommit != null) {
                config.setAncestorLabel(NLS.bind((String)LABELPATTERN, (Object)ancestorCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(ancestorCommit.name())));
            }
            this.setTitle(NLS.bind((String)UIText.GitMergeEditorInput_MergeEditorTitle, (Object[])new Object[]{Activator.getDefault().getRepositoryUtil().getRepositoryName(repo), rightCommit.getShortMessage(), fullBranch}));
            try {
                IDiffContainer iDiffContainer = this.buildDiffContainer(repo, headCommit, ancestorCommit, filterPaths, rw, monitor);
                return iDiffContainer;
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (rw != null) {
                rw.dispose();
            }
            monitor.done();
        }
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.getNavigator().selectChange(true);
    }

    protected void handleDispose() {
        super.handleDispose();
    }

    private IDiffContainer buildDiffContainer(Repository repository, RevCommit headCommit, RevCommit ancestorCommit, List<String> filterPaths, RevWalk rw, IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.setTaskName(UIText.GitMergeEditorInput_CalculatingDiffTaskName);
        DiffNode result = new DiffNode(12);
        Throwable throwable = null;
        Object var9_10 = null;
        try (TreeWalk tw = new TreeWalk(repository);){
            int dirCacheIndex = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
            int fileTreeIndex = tw.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
            int repositoryTreeIndex = tw.addTree((AnyObjectId)rw.parseTree((AnyObjectId)repository.resolve("HEAD")));
            NotIgnoredFilter notIgnoredFilter = new NotIgnoredFilter(fileTreeIndex);
            if (filterPaths.size() > 1) {
                ArrayList<PathFilter> suffixFilters = new ArrayList<PathFilter>();
                for (String filterPath : filterPaths) {
                    suffixFilters.add(PathFilter.create((String)filterPath));
                }
                TreeFilter otf = OrTreeFilter.create(suffixFilters);
                tw.setFilter(AndTreeFilter.create((TreeFilter)otf, (TreeFilter)notIgnoredFilter));
            } else if (filterPaths.size() > 0) {
                String path = filterPaths.get(0);
                if (path.length() == 0) {
                    tw.setFilter((TreeFilter)notIgnoredFilter);
                } else {
                    tw.setFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)notIgnoredFilter));
                }
            } else {
                tw.setFilter((TreeFilter)notIgnoredFilter);
            }
            tw.setRecursive(true);
            while (tw.next()) {
                ITypedElement right;
                boolean modified;
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String gitPath = tw.getPathString();
                monitor.setTaskName(gitPath);
                FileTreeIterator fit = (FileTreeIterator)tw.getTree(fileTreeIndex, FileTreeIterator.class);
                if (fit == null) continue;
                DirCacheIterator dit = (DirCacheIterator)tw.getTree(dirCacheIndex, DirCacheIterator.class);
                DirCacheEntry dirCacheEntry = dit == null ? null : dit.getDirCacheEntry();
                boolean conflicting = dirCacheEntry != null && dirCacheEntry.getStage() > 0;
                AbstractTreeIterator rt = tw.getTree(repositoryTreeIndex, AbstractTreeIterator.class);
                boolean bl = modified = rt != null && !fit.getEntryObjectId().equals((AnyObjectId)rt.getEntryObjectId());
                if (!conflicting && !modified) continue;
                if (conflicting) {
                    GitFileRevision revision = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)3);
                    String encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                    right = new FileRevisionTypedElement((IFileRevision)revision, encoding);
                } else {
                    right = CompareUtils.getFileRevisionTypedElement(gitPath, headCommit, repository);
                }
                if (right instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) continue;
                Path repositoryPath = new Path(repository.getWorkTree().getAbsolutePath());
                IPath location = repositoryPath.append(fit.getEntryPathString());
                IFile file = ResourceUtil.getFileForLocation((IPath)location, (boolean)false);
                LocalFileRevision rev = !conflicting || this.useWorkspace ? (file != null ? new LocalFileRevision(file) : new WorkingTreeFileRevision(location.toFile())) : GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)2);
                ICompareContainer runnableContext = this.getContainer();
                if (runnableContext == null) {
                    runnableContext = PlatformUI.getWorkbench().getProgressService();
                }
                EditableRevision leftEditable = file != null ? new ResourceEditableRevision((IFileRevision)rev, file, (IRunnableContext)runnableContext) : new LocationEditableRevision((IFileRevision)rev, location, (IRunnableContext)runnableContext);
                try {
                    leftEditable.cacheContents(monitor);
                }
                catch (CoreException e) {
                    throw new IOException(e.getMessage());
                }
                int kind = 0;
                if (conflicting) {
                    kind = 12;
                } else if (modified) {
                    kind = 16;
                }
                IDiffContainer fileParent = this.getFileParent((IDiffContainer)result, (IPath)repositoryPath, file, location);
                ITypedElement anc = ancestorCommit != null ? CompareUtils.getFileRevisionTypedElement(gitPath, ancestorCommit, repository) : null;
                if (anc instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) {
                    anc = null;
                }
                new DiffNode(fileParent, kind, anc, (ITypedElement)leftEditable, right);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IDiffContainer getFileParent(IDiffContainer root, IPath repositoryPath, IFile file, IPath location) {
        IProject project;
        IPath projectLocation;
        int projectSegment = -1;
        String projectName = null;
        if (file != null && (projectLocation = (project = file.getProject()).getLocation()) != null) {
            IPath projectPath = project.getLocation().makeRelativeTo(repositoryPath);
            projectSegment = projectPath.segmentCount() - 1;
            projectName = project.getName();
        }
        IPath path = location.makeRelativeTo(repositoryPath);
        IDiffContainer child = root;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            child = i == projectSegment ? this.getOrCreateChild(child, projectName, true) : this.getOrCreateChild(child, path.segment(i), false);
            ++i;
        }
        return child;
    }

    private DiffNode getOrCreateChild(IDiffContainer parent, final String name, final boolean projectMode) {
        Object child;
        IDiffElement[] iDiffElementArray = parent.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iDiffElementArray[n2];
            if (child.getName().equals(name)) {
                return (DiffNode)child;
            }
            ++n2;
        }
        child = new DiffNode(parent, 0){

            public String getName() {
                return name;
            }

            public Image getImage() {
                if (projectMode) {
                    return PROJECT_IMAGE;
                }
                return FOLDER_IMAGE;
            }
        };
        return child;
    }

    private String readFile(File directory, String fileName) throws IOException {
        byte[] content = IO.readFully((File)new File(directory, fileName));
        int end = content.length;
        while (end > 0 && content[end - 1] == 10) {
            --end;
        }
        return RawParseUtils.decode((byte[])content, (int)0, (int)end);
    }
}

