/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.log;

import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.fx.core.log.Condition;
import org.eclipse.fx.core.log.FluentLogContext;

public class Throttle
extends Condition {
    public Throttle(FluentLogContext context) {
        super(context);
    }

    public FluentLogContext interval(long interval, TimeUnit unit) {
        this.context.when(new TimePredicate(unit.toNanos(interval)));
        return this.context;
    }

    public FluentLogContext every(long nTime) {
        this.context.when(new CountPredicate(nTime));
        return this.context;
    }

    static class CountPredicate
    implements Predicate<FluentLogContext.MutableState> {
        private final long nTimes;

        public CountPredicate(long nTimes) {
            this.nTimes = nTimes;
        }

        @Override
        public boolean test(FluentLogContext.MutableState t) {
            return t.lastLogCount() + this.nTimes - t.currentCallCount() < 0L;
        }
    }

    static class TimePredicate
    implements Predicate<FluentLogContext.MutableState> {
        private final long interval;

        public TimePredicate(long interval) {
            this.interval = interval;
        }

        @Override
        public boolean test(FluentLogContext.MutableState t) {
            return t.lastLogTime() + this.interval - System.nanoTime() > 0L;
        }
    }
}

