/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.databinding.internal;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.fx.core.databinding.IJFXBeanValueProperty;
import org.eclipse.fx.core.databinding.JFXBeanProperties;
import org.eclipse.fx.core.databinding.internal.FXBeanObservableValueDecorator;

public class FXBeanValuePropertyDecorator
extends ValueProperty
implements IJFXBeanValueProperty {
    private final IValueProperty delegate;
    private final PropertyDescriptor propertyDescriptor;

    public FXBeanValuePropertyDecorator(IValueProperty delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    protected Object doGetValue(Object source) {
        return this.delegate.getValue(source);
    }

    protected void doSetValue(Object source, Object value) {
        this.delegate.setValue(source, value);
    }

    @Override
    public IJFXBeanValueProperty value(String propertyName) {
        return this.value(propertyName, null);
    }

    @Override
    public IJFXBeanValueProperty value(String propertyName, Class<?> valueType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.value(JFXBeanProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public IJFXBeanValueProperty value(IJFXBeanValueProperty property) {
        return new FXBeanValuePropertyDecorator(super.value((IValueProperty)property), property.getPropertyDescriptor());
    }

    public IObservableValue observe(Object source) {
        return new FXBeanObservableValueDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableValue observe(Realm realm, Object source) {
        return new FXBeanObservableValueDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public IObservableValue observeDetail(IObservableValue master) {
        return new FXBeanObservableValueDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

