/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.fx.ui.databinding.internal.ControlValueProperty;

public abstract class ControlReadOnlyPropertyValueProperty<O>
extends ControlValueProperty {
    protected Object doGetValue(Object source) {
        ReadOnlyProperty<O> p = this.getProperty(source);
        return p != null ? p.getValue() : null;
    }

    protected abstract ReadOnlyProperty<O> getProperty(Object var1);

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new ListenerImpl((IProperty)this, listener);
    }

    class ListenerImpl
    extends NativePropertyListener
    implements ChangeListener<Object> {
        private Object owner;

        public ListenerImpl(IProperty property, ISimplePropertyListener listener) {
            super(property, listener);
        }

        public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            this.fireChange(this.owner, (IDiff)Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        }

        protected void doAddTo(Object source) {
            this.owner = source;
            ReadOnlyProperty p = ControlReadOnlyPropertyValueProperty.this.getProperty(source);
            if (p != null) {
                p.addListener((ChangeListener)this);
            }
        }

        protected void doRemoveFrom(Object source) {
            this.owner = null;
            ReadOnlyProperty p = ControlReadOnlyPropertyValueProperty.this.getProperty(source);
            if (p != null) {
                p.removeListener((ChangeListener)this);
            }
        }
    }
}

