/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.p2;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.ReturnValue;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.core.p2.Activator;
import org.eclipse.fx.core.update.UpdateService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.ServiceReference;

public class UpdateServiceImpl
implements UpdateService {
    private Logger logger;
    private LoggerFactory factory;

    public void setLoggerFactory(LoggerFactory factory) {
        this.factory = factory;
        if (this.logger != null) {
            this.logger = null;
        }
    }

    public void unsetLoggerFactory(LoggerFactory factory) {
        if (this.factory == factory) {
            this.factory = null;
            this.logger = null;
        }
    }

    @NonNull
    private Logger getLogger() {
        if (this.factory == null) {
            throw new IllegalStateException("No logger factory available");
        }
        if (this.logger == null) {
            this.logger = this.factory.createLogger(this.getClass().getName());
        }
        return this.logger;
    }

    public void update(UpdateService.UpdateCheckData data, final Callback<UpdateService.UpdateData> callback) {
        UpdateOperation updateOperation = ((P2UpdateCheckRV)data).updateOperation;
        if (updateOperation != null) {
            ProvisioningJob job = updateOperation.getProvisioningJob((IProgressMonitor)new NullProgressMonitor());
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus s = event.getResult();
                    ReturnValue.State state = UpdateServiceImpl.fromStatus(s);
                    callback.call((Object)new P2UpdateRV(state, s.getMessage(), ReturnValue.State.OK == state, s.getException()));
                }
            });
            job.schedule();
        }
    }

    @NonNull
    static ReturnValue.State fromStatus(IStatus s) {
        switch (s.getSeverity()) {
            case 8: {
                return ReturnValue.State.CANCEL;
            }
            case 4: {
                return ReturnValue.State.ERROR;
            }
            case 2: {
                return ReturnValue.State.WARNING;
            }
        }
        return ReturnValue.State.OK;
    }

    public void checkUpdate(final Callback<UpdateService.UpdateCheckData> callback) {
        try {
            IProvisioningAgent agent = UpdateServiceImpl.getProvisioningAgent();
            final ProvisioningSession session = new ProvisioningSession(agent);
            Job o = new Job("Check for Updates"){

                protected IStatus run(IProgressMonitor monitor) {
                    UpdateOperation o = new UpdateOperation(session);
                    IStatus s = o.resolveModal(monitor);
                    ReturnValue.State state = UpdateServiceImpl.fromStatus(s);
                    callback.call((Object)new P2UpdateCheckRV(o, state, s.getMessage(), state == ReturnValue.State.OK, s.getException()));
                    return Status.OK_STATUS;
                }
            };
            o.schedule();
        }
        catch (ProvisionException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            callback.call((Object)new P2UpdateCheckRV(null, ReturnValue.State.ERROR, "Failure while try to collect updateable units", Boolean.FALSE, e));
        }
    }

    private static IProvisioningAgent getProvisioningAgent() throws ProvisionException {
        ServiceReference reference = Activator.getContext().getServiceReference(IProvisioningAgent.SERVICE_NAME);
        IProvisioningAgent agent = (IProvisioningAgent)Activator.getContext().getService(reference);
        return agent;
    }

    static class P2UpdateCheckRV
    extends ReturnValue.ReturnValueImpl<Boolean>
    implements UpdateService.UpdateCheckData {
        @Nullable
        public final UpdateOperation updateOperation;

        public P2UpdateCheckRV(@Nullable UpdateOperation updateOperation, @NonNull ReturnValue.State state, @NonNull String message, @NonNull Boolean value, @Nullable Throwable throwable) {
            super(state, message, (Object)value, throwable);
            this.updateOperation = updateOperation;
        }
    }

    static class P2UpdateRV
    extends ReturnValue.ReturnValueImpl<Boolean>
    implements UpdateService.UpdateData {
        public P2UpdateRV(@NonNull ReturnValue.State state, @NonNull String message, @NonNull Boolean value, @Nullable Throwable throwable) {
            super(state, message, (Object)value, throwable);
        }
    }
}

