/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;

public class AntlrToolFacade {
    private static final Logger log = Logger.getLogger(AntlrToolFacade.class);
    public static final String className = "de.itemis.xtext.antlr.toolrunner.AntlrToolRunner";
    private ClassLoader loader = AntlrToolFacade.class.getClassLoader();
    private String downloadURL = "http://download.itemis.com/antlr-generator-3.2.0-patch.jar";
    private boolean askBeforeDownload = true;
    private String downloadTo = "./.antlr-generator-3.2.0-patch.jar";

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setAskBeforeDownload(boolean shouldAsk) {
        this.askBeforeDownload = shouldAsk;
    }

    public void setDownloadFrom(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public void setDownloadTo(String path) {
        this.downloadTo = path;
    }

    protected File file() {
        return new File(this.downloadTo);
    }

    protected String getToolRunnerClassName() {
        return className;
    }

    protected Class<?> getToolClass() {
        try {
            return this.loader.loadClass(this.getToolRunnerClassName());
        }
        catch (ClassNotFoundException e) {
            if (!this.file().exists() && !this.download()) {
                return null;
            }
            if (this.file().exists()) {
                URL url = this.file().toURI().toURL();
                this.loader = new URLClassLoader(new URL[]{url}, this.loader);
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.loader);
                    Class<?> clazz = this.loader.loadClass(className);
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    return clazz;
                }
                catch (Throwable throwable) {
                    try {
                        Thread.currentThread().setContextClassLoader(contextClassLoader);
                        throw throwable;
                    }
                    catch (MalformedURLException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    catch (ClassNotFoundException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean download() {
        try {
            if (this.askBeforeDownload) {
                boolean ok = false;
                while (!ok) {
                    System.err.print("\n*ATTENTION*\nIt is recommended to use the ANTLR 3 parser generator (BSD licence - http://www.antlr.org/license.html).\nDo you agree to download it (size 1MB) from '" + this.downloadURL + "'? (type 'y' or 'n' and hit enter)");
                    int read = System.in.read();
                    if (read == 110) {
                        return false;
                    }
                    if (read != 121) continue;
                    ok = true;
                }
            }
            log.info((Object)("downloading file from '" + this.downloadURL + "' ..."));
            BufferedInputStream in = new BufferedInputStream(new URL(this.downloadURL).openStream());
            try {
                FileOutputStream out = new FileOutputStream(this.file());
                try {
                    byte[] buffer = new byte[2048];
                    int readBytes = -1;
                    while ((readBytes = in.read(buffer)) != -1) {
                        out.write(buffer, 0, readBytes);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
            log.info((Object)"finished downloading.");
        }
        catch (IOException e) {
            System.err.println("Downloading ANTLR parser generator failed: " + e.getMessage());
            System.err.println("Please install the feature 'Xtext Antlr SDK' manually using the external updatesite:");
            System.err.println();
            System.err.println("\t\t'http://download.itemis.com/updates/'.");
            System.err.println();
            System.err.println("(see http://www.eclipse.org/Xtext/download.html for details)");
            return false;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if (this.getToolClass() == null) {
            log.error((Object)"Loaded jar doesn't contain de.itemis.xtext.antlr.toolrunner.AntlrToolRunner");
            return false;
        }
        return true;
    }

    private IllegalStateException getNoClassFoundException() {
        return new IllegalStateException("Couldn't find ANTLR generator on class path. Please download manually from '" + this.downloadURL + "' and put it on the classpath.");
    }

    @Deprecated
    public void runWithParams(String grammarFullPath, String ... furtherArgs) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.loader);
                Class<?> class1 = this.getToolClass();
                if (class1 == null) {
                    throw this.getNoClassFoundException();
                }
                Method method = class1.getMethod("runWithParams", String.class, String[].class);
                method.invoke(null, grammarFullPath, furtherArgs);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void runWithEncodingAndParams(String grammarFullPath, String explicitEncoding, String ... furtherArgs) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.loader);
                Class<?> class1 = this.getToolClass();
                if (class1 == null) {
                    throw this.getNoClassFoundException();
                }
                Method method = class1.getMethod("runWithEncodingAndParams", String.class, String.class, String[].class);
                method.invoke(null, grammarFullPath, explicitEncoding, furtherArgs);
            }
            catch (NoSuchMethodException e) {
                if (explicitEncoding != null && !Charset.defaultCharset().name().equals(explicitEncoding)) {
                    throw new IllegalStateException("Explicit encoding was set but is not supported by the available version of the AntlrToolRunner.\nPlease use the ANTLR parser generator in version 2.1 or better");
                }
                this.runWithParams(grammarFullPath, furtherArgs);
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public boolean isWorkable() {
        return this.getToolClass() != null;
    }
}

