/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.nodemodel.serialization.DeserializationConversionContext;
import org.eclipse.xtext.nodemodel.serialization.SerializationConversionContext;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class SerializableNodeModel {
    public int formatVersion;
    public Date date;
    public RootNode root;

    public SerializableNodeModel(XtextResource resource) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ICompositeNode rootNode = parseResult.getRootNode();
            this.root = (RootNode)rootNode;
        }
        this.formatVersion = 1;
        this.date = new Date();
    }

    public SerializableNodeModel() {
    }

    public void writeObjectData(DataOutputStream out, SerializationConversionContext scc) throws IOException {
        String[] grammarIdToURIMap = scc.getGrammarIdToURIMap();
        out.writeInt(grammarIdToURIMap.length);
        for (String string : grammarIdToURIMap) {
            out.writeUTF(string);
        }
        this.root.write(out, scc);
    }

    public void readObjectData(DataInputStream in, DeserializationConversionContext context) throws IOException {
        int grammarIdToURIMapLength = in.readInt();
        String[] grammarIdToURIMap = new String[grammarIdToURIMapLength];
        for (int i = 0; i < grammarIdToURIMapLength; ++i) {
            grammarIdToURIMap[i] = in.readUTF();
            if (grammarIdToURIMap[i] != null) continue;
            throw new IllegalStateException("During deserialzing the grammar id to URI map got a null reference. ");
        }
        context.setGrammarIdToURIMap(grammarIdToURIMap);
        this.root = new RootNode();
        this.root.readData(in, context);
    }
}

