/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.stage.Window;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.log.LoggerCreator;

public class JavaFXCompatUtil {
    public static List<Window> getAllWindows() {
        try {
            if (SystemUtils.isFX9()) {
                return (List)Window.class.getMethod("getWindows", new Class[0]).invoke(null, new Object[0]);
            }
            Iterator it = (Iterator)Window.class.getMethod("impl_getWindows", new Class[0]).invoke(null, new Object[0]);
            ArrayList<Window> rv = new ArrayList<Window>();
            while (it.hasNext()) {
                rv.add((Window)it.next());
            }
            return Collections.unmodifiableList(rv);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static int getCode(KeyCode keyCode) {
        if (SystemUtils.isFX9()) {
            try {
                return (Integer)KeyCode.class.getMethod("getCode", new Class[0]).invoke((Object)keyCode, new Object[0]);
            }
            catch (Throwable t) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#getCode()", t);
                throw new RuntimeException(t);
            }
        }
        try {
            return (Integer)KeyCode.class.getMethod("impl_getCode", new Class[0]).invoke((Object)keyCode, new Object[0]);
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#impl_getCode()", t);
            throw new RuntimeException(t);
        }
    }

    public static String getChar(KeyCode keyCode) {
        if (SystemUtils.isFX9()) {
            try {
                return (String)KeyCode.class.getMethod("getChar", new Class[0]).invoke((Object)keyCode, new Object[0]);
            }
            catch (Throwable t) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#getChar()", t);
                throw new RuntimeException(t);
            }
        }
        try {
            return (String)KeyCode.class.getMethod("impl_getChar", new Class[0]).invoke((Object)keyCode, new Object[0]);
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call KeyCode#impl_getChar()", t);
            throw new RuntimeException(t);
        }
    }

    public static void reapplyCSS(Node node) {
        if (SystemUtils.isFX9()) {
            try {
                Method m = Node.class.getDeclaredMethod("reapplyCSS", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)node, new Object[0]);
            }
            catch (Throwable t) {
                LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Node#reapplyCSS()", t);
                throw new RuntimeException(t);
            }
        }
        try {
            Method m = Node.class.getDeclaredMethod("impl_reapplyCSS", new Class[0]);
            m.invoke((Object)node, new Object[0]);
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(JavaFXCompatUtil.class).error("Unable to call Node#impl_reapplyCSS()", t);
            throw new RuntimeException(t);
        }
    }
}

