/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.ITokenSerializer;

public class ValueSerializer
implements ITokenSerializer.IValueSerializer {
    @Inject
    private IValueConverterService converter;

    @Override
    public boolean equalsOrReplacesNode(EObject context, RuleCall ruleCall, INode node) {
        return ruleCall == node.getGrammarElement();
    }

    @Override
    public boolean equalsOrReplacesNode(EObject context, RuleCall ruleCall, Object value, INode node) {
        if (ruleCall != node.getGrammarElement()) {
            return false;
        }
        Assignment ass = GrammarUtil.containingAssignment(ruleCall);
        if (GrammarUtil.isSingleAssignment(ass)) {
            return true;
        }
        Object converted = this.converter.toValue(this.serialize(node), ruleCall.getRule().getName(), node);
        return converted != null && converted.equals(value);
    }

    @Override
    public boolean isValid(EObject context, RuleCall ruleCall, Object value, ITokenSerializer.IErrorAcceptor errorAcceptor) {
        try {
            String str = this.converter.toString(value, ruleCall.getRule().getName());
            if (str != null) {
                return true;
            }
            if (errorAcceptor != null) {
                errorAcceptor.error("The value may not be null.");
            }
            return false;
        }
        catch (Throwable e) {
            if (errorAcceptor != null) {
                errorAcceptor.error(e.getMessage());
            }
            return false;
        }
    }

    protected String serialize(INode node) {
        if (node instanceof ILeafNode) {
            return ((ILeafNode)node).getText();
        }
        StringBuilder builder = new StringBuilder(node.getLength());
        boolean hiddenSeen = false;
        for (ILeafNode leaf : node.getLeafNodes()) {
            if (!leaf.isHidden()) {
                if (hiddenSeen && builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(leaf.getText());
                hiddenSeen = false;
                continue;
            }
            hiddenSeen = true;
        }
        return builder.toString();
    }

    @Override
    public String serializeAssignedValue(EObject context, RuleCall ruleCall, Object value, INode node) {
        Object converted;
        if (node != null && (converted = this.converter.toValue(this.serialize(node), ruleCall.getRule().getName(), node)) != null && converted.equals(value)) {
            return "<KEEP_VALUE_FROM_NODE_MODEL>";
        }
        return this.converter.toString(value, ruleCall.getRule().getName());
    }

    @Override
    public String serializeUnassignedValue(EObject context, RuleCall ruleCall, INode node) {
        String r = this.serializeUnassignedValueByRuleCall(ruleCall, context, node);
        if (r != null) {
            return r;
        }
        r = this.serializeUnassignedValueByRule(ruleCall.getRule(), context, node);
        if (r != null) {
            return r;
        }
        if (node != null) {
            return "<KEEP_VALUE_FROM_NODE_MODEL>";
        }
        throw new IllegalArgumentException("Could not determine the value for the unassigned rulecall of rule " + ruleCall.getRule().getName() + " from within rule " + GrammarUtil.containingRule(ruleCall).getName() + ". You might want to implement " + ITokenSerializer.IValueSerializer.class.getName() + ".serializeUnassignedValue() or modify your implementation to handle this rulecall.");
    }

    protected String serializeUnassignedValueByRule(AbstractRule rule, EObject current, INode node) {
        return null;
    }

    protected String serializeUnassignedValueByRuleCall(RuleCall ruleCall, EObject current, INode node) {
        return null;
    }
}

