/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class SingleProjectWorkspaceConfig
implements IWorkspaceConfig {
    private final IProjectConfig projectConfig;

    @Override
    public IProjectConfig findProjectByName(String name) {
        String _name = this.projectConfig.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)name);
        if (_equals) {
            return this.projectConfig;
        }
        return null;
    }

    @Override
    public IProjectConfig findProjectContaining(URI member) {
        boolean _isPrefixOf = UriUtil.isPrefixOf((URI)this.projectConfig.getPath(), (URI)member);
        if (_isPrefixOf) {
            return this.projectConfig;
        }
        return null;
    }

    @Override
    public Set<? extends IProjectConfig> getProjects() {
        return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new IProjectConfig[]{this.projectConfig}));
    }

    public SingleProjectWorkspaceConfig(IProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.projectConfig == null ? 0 : this.projectConfig.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleProjectWorkspaceConfig other = (SingleProjectWorkspaceConfig)obj;
        return !(this.projectConfig == null ? other.projectConfig != null : !this.projectConfig.equals(other.projectConfig));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("projectConfig", (Object)this.projectConfig);
        return b.toString();
    }

    @Pure
    public IProjectConfig getProjectConfig() {
        return this.projectConfig;
    }
}

