/**
 * Copyright (c) 2008-2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 */
package org.eclipse.emf.codegen.ecore.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Gen Runtime Version</b></em>',
 * and utility methods for working with them.
 * @since 2.4
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage#getGenRuntimeVersion()
 * @model
 * @generated
 */
public enum GenRuntimeVersion implements Enumerator
{
  /**
   * The '<em><b>EMF22</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF22_VALUE
   * @generated
   * @ordered
   */
  EMF22(0, "EMF22", "2.2"),

  /**
   * The '<em><b>EMF23</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF23_VALUE
   * @generated
   * @ordered
   */
  EMF23(1, "EMF23", "2.3"),

  /**
   * The '<em><b>EMF24</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF24_VALUE
   * @generated
   * @ordered
   */
  EMF24(2, "EMF24", "2.4"),

  /**
   * The '<em><b>EMF25</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF25_VALUE
   * @generated
   * @ordered
   */
  EMF25(3, "EMF25", "2.5"),

  /**
   * The '<em><b>EMF26</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF26_VALUE
   * @generated
   * @ordered
   */
  EMF26(4, "EMF26", "2.6"),

  /**
   * The '<em><b>EMF27</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF27_VALUE
   * @generated
   * @ordered
   */
  EMF27(5, "EMF27", "2.7"),

  /**
   * The '<em><b>EMF28</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF28_VALUE
   * @generated
   * @ordered
   */
  EMF28(6, "EMF28", "2.8"),

  /**
   * The '<em><b>EMF29</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF29_VALUE
   * @generated
   * @ordered
   */
  EMF29(7, "EMF29", "2.9"),

  /**
   * The '<em><b>EMF210</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF210_VALUE
   * @generated
   * @ordered
   */
  EMF210(8, "EMF210", "2.10"),

  /**
   * The '<em><b>EMF211</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF211_VALUE
   * @generated
   * @ordered
   */
  EMF211(9, "EMF211", "2.11"),

  /**
   * The '<em><b>EMF212</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF212_VALUE
   * @generated
   * @ordered
   */
  EMF212(10, "EMF212", "2.12"),

  /**
   * The '<em><b>EMF213</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF213_VALUE
   * @generated
   * @ordered
   */
  EMF213(11, "EMF213", "2.13"),

  /**
   * The '<em><b>EMF214</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.14
   * <!-- end-model-doc -->
   * @see #EMF214_VALUE
   * @generated
   * @ordered
   */
  EMF214(12, "EMF214", "2.14"),

  /**
   * The '<em><b>EMF215</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.16
   * <!-- end-model-doc -->
   * @see #EMF215_VALUE
   * @generated
   * @ordered
   */
  EMF215(13, "EMF215", "2.15"),

  /**
   * The '<em><b>EMF216</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.16
   * <!-- end-model-doc -->
   * @see #EMF216_VALUE
   * @generated
   * @ordered
   */
  EMF216(14, "EMF216", "2.16"),

  /**
   * The '<em><b>EMF217</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.17
   * <!-- end-model-doc -->
   * @see #EMF217_VALUE
   * @generated
   * @ordered
   */
  EMF217(15, "EMF217", "2.17"),

  /**
   * The '<em><b>EMF218</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.18
   * <!-- end-model-doc -->
   * @see #EMF218_VALUE
   * @generated
   * @ordered
   */
  EMF218(16, "EMF218", "2.18"),

  /**
   * The '<em><b>EMF219</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.19
   * <!-- end-model-doc -->
   * @see #EMF219_VALUE
   * @generated
   * @ordered
   */
  EMF219(17, "EMF219", "2.19"),

  /**
   * The '<em><b>EMF220</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.20
   * <!-- end-model-doc -->
   * @see #EMF220_VALUE
   * @generated
   * @ordered
   */
  EMF220(18, "EMF220", "2.20"),

  /**
   * The '<em><b>EMF221</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.21
   * <!-- end-model-doc -->
   * @see #EMF221_VALUE
   * @generated
   * @ordered
   */
  EMF221(19, "EMF221", "2.21"),

  /**
   * The '<em><b>EMF222</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.22
   * <!-- end-model-doc -->
   * @see #EMF222_VALUE
   * @generated
   * @ordered
   */
  EMF222(20, "EMF222", "2.22"),

  /**
   * The '<em><b>EMF223</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.23
   * <!-- end-model-doc -->
   * @see #EMF223_VALUE
   * @generated
   * @ordered
   */
  EMF223(21, "EMF223", "2.23"),

  /**
   * The '<em><b>EMF224</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.24
   * <!-- end-model-doc -->
   * @see #EMF224_VALUE
   * @generated
   * @ordered
   */
  EMF224(22, "EMF224", "2.24"),

  /**
   * The '<em><b>EMF225</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.25
   * <!-- end-model-doc -->
   * @see #EMF225_VALUE
   * @generated
   * @ordered
   */
  EMF225(23, "EMF225", "2.25"),

  /**
   * The '<em><b>EMF226</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.26
   * <!-- end-model-doc -->
   * @see #EMF226_VALUE
   * @generated
   * @ordered
   */
  EMF226(24, "EMF226", "2.26"),

  /**
   * The '<em><b>EMF227</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.27
   * <!-- end-model-doc -->
   * @see #EMF227_VALUE
   * @generated
   * @ordered
   */
  EMF227(25, "EMF227", "2.27"),

  /**
   * The '<em><b>EMF228</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.28
   * <!-- end-model-doc -->
   * @see #EMF228_VALUE
   * @generated
   * @ordered
   */
  EMF228(26, "EMF228", "2.28"),

  /**
   * The '<em><b>EMF229</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.29
   * <!-- end-model-doc -->
   * @see #EMF229_VALUE
   * @generated
   * @ordered
   */
  EMF229(27, "EMF229", "2.29"),

  /**
   * The '<em><b>EMF230</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.30
   * <!-- end-model-doc -->
   * @see #EMF230_VALUE
   * @generated
   * @ordered
   */
  EMF230(28, "EMF230", "2.30"), /**
   * The '<em><b>EMF231</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.31
   * <!-- end-model-doc -->
   * @see #EMF231_VALUE
   * @generated
   * @ordered
   */
  EMF231(29, "EMF231", "2.31"),
  /**
   * The '<em><b>EMF232</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.32
   * <!-- end-model-doc -->
   * @see #EMF232_VALUE
   * @generated
   * @ordered
   */
  EMF232(30, "EMF232", "2.32"),
  /**
   * The '<em><b>EMF233</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.33
   * <!-- end-model-doc -->
   * @see #EMF233_VALUE
   * @generated
   * @ordered
   */
  EMF233(31, "EMF233", "2.33"),
  /**
   * The '<em><b>EMF234</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.34
   * <!-- end-model-doc -->
   * @see #EMF234_VALUE
   * @generated
   * @ordered
   */
  EMF234(32, "EMF234", "2.34"),
  /**
   * The '<em><b>EMF235</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.35
   * <!-- end-model-doc -->
   * @see #EMF235_VALUE
   * @generated
   * @ordered
   */
  EMF235(33, "EMF235", "2.35"),
  /**
   * The '<em><b>EMF236</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.36
   * <!-- end-model-doc -->
   * @see #EMF236_VALUE
   * @generated
   * @ordered
   */
  EMF236(34, "EMF236", "2.36"),
  /**
   * The '<em><b>EMF237</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.37
   * <!-- end-model-doc -->
   * @see #EMF237_VALUE
   * @generated
   * @ordered
   */
  EMF237(35, "EMF237", "2.37"),
  /**
   * The '<em><b>EMF238</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.38
   * <!-- end-model-doc -->
   * @see #EMF238_VALUE
   * @generated
   * @ordered
   */
  EMF238(36, "EMF238", "2.38"),
  /**
   * The '<em><b>EMF239</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.39
   * <!-- end-model-doc -->
   * @see #EMF239_VALUE
   * @generated
   * @ordered
   */
  EMF239(37, "EMF239", "2.39"),
  /**
   * The '<em><b>EMF240</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.40
   * <!-- end-model-doc -->
   * @see #EMF240_VALUE
   * @generated
   * @ordered
   */
  EMF240(38, "EMF240", "2.40");

  /**
   * The '<em><b>EMF22</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF22
   * @model literal="2.2"
   * @generated
   * @ordered
   */
  public static final int EMF22_VALUE = 0;

  /**
   * The '<em><b>EMF23</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF23
   * @model literal="2.3"
   * @generated
   * @ordered
   */
  public static final int EMF23_VALUE = 1;

  /**
   * The '<em><b>EMF24</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF24
   * @model literal="2.4"
   * @generated
   * @ordered
   */
  public static final int EMF24_VALUE = 2;

  /**
   * The '<em><b>EMF25</b></em>' literal value.
   * <!-- begin-user-doc -->
   * @since 2.5
   * <!-- end-user-doc -->
   * @see #EMF25
   * @model literal="2.5"
   * @generated
   * @ordered
   */
  public static final int EMF25_VALUE = 3;

  /**
   * The '<em><b>EMF26</b></em>' literal value.
   * <!-- begin-user-doc -->
   * @since 2.6
   * <!-- end-user-doc -->
   * @see #EMF26
   * @model literal="2.6"
   * @generated
   * @ordered
   */
  public static final int EMF26_VALUE = 4;

  /**
   * The '<em><b>EMF27</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <p>
   * @since 2.7
   * </p>
   * <!-- end-user-doc -->
   * @see #EMF27
   * @model literal="2.7"
   * @generated
   * @ordered
   */
  public static final int EMF27_VALUE = 5;

  /**
   * The '<em><b>EMF28</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <p>
   * @since 2.8
   * </p>
   * <!-- end-user-doc -->
   * @see #EMF28
   * @model literal="2.8"
   * @generated
   * @ordered
   */
  public static final int EMF28_VALUE = 6;

  /**
   * The '<em><b>EMF29</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <p>
   * @since 2.9
   * </p>
   * <!-- end-user-doc -->
   * @see #EMF29
   * @model literal="2.9"
   * @generated
   * @ordered
   */
  public static final int EMF29_VALUE = 7;

  /**
   * The '<em><b>EMF210</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <p>
   * @since 2.10
   * </p>
   * <!-- end-user-doc -->
   * @see #EMF210
   * @model literal="2.10"
   * @generated
   * @ordered
   */
  public static final int EMF210_VALUE = 8;

  /**
   * The '<em><b>EMF211</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF211
   * @model literal="2.11"
   * @generated
   * @ordered
   */
  public static final int EMF211_VALUE = 9;

  /**
   * The '<em><b>EMF212</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF212
   * @model literal="2.12"
   * @generated
   * @ordered
   */
  public static final int EMF212_VALUE = 10;

  /**
   * The '<em><b>EMF213</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #EMF213
   * @model literal="2.13"
   * @generated
   * @ordered
   */
  public static final int EMF213_VALUE = 11;

  /**
   * The '<em><b>EMF214</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.14
   * <!-- end-model-doc -->
   * @see #EMF214
   * @model literal="2.14"
   * @generated
   * @ordered
   */
  public static final int EMF214_VALUE = 12;

  /**
   * The '<em><b>EMF215</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.16
   * <!-- end-model-doc -->
   * @see #EMF215
   * @model literal="2.15"
   * @generated
   * @ordered
   */
  public static final int EMF215_VALUE = 13;

  /**
   * The '<em><b>EMF216</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.16
   * <!-- end-model-doc -->
   * @see #EMF216
   * @model literal="2.16"
   * @generated
   * @ordered
   */
  public static final int EMF216_VALUE = 14;

  /**
   * The '<em><b>EMF217</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.17
   * <!-- end-model-doc -->
   * @see #EMF217
   * @model literal="2.17"
   * @generated
   * @ordered
   */
  public static final int EMF217_VALUE = 15;

  /**
   * The '<em><b>EMF218</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.18
   * <!-- end-model-doc -->
   * @see #EMF218
   * @model literal="2.18"
   * @generated
   * @ordered
   */
  public static final int EMF218_VALUE = 16;

  /**
   * The '<em><b>EMF219</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.19
   * <!-- end-model-doc -->
   * @see #EMF219
   * @model literal="2.19"
   * @generated
   * @ordered
   */
  public static final int EMF219_VALUE = 17;

  /**
   * The '<em><b>EMF220</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.20
   * <!-- end-model-doc -->
   * @see #EMF220
   * @model literal="2.20"
   * @generated
   * @ordered
   */
  public static final int EMF220_VALUE = 18;

  /**
   * The '<em><b>EMF221</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.21
   * <!-- end-model-doc -->
   * @see #EMF221
   * @model literal="2.21"
   * @generated
   * @ordered
   */
  public static final int EMF221_VALUE = 19;

  /**
   * The '<em><b>EMF222</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.22
   * <!-- end-model-doc -->
   * @see #EMF222
   * @model literal="2.22"
   * @generated
   * @ordered
   */
  public static final int EMF222_VALUE = 20;

  /**
   * The '<em><b>EMF223</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.23
   * <!-- end-model-doc -->
   * @see #EMF223
   * @model literal="2.23"
   * @generated
   * @ordered
   */
  public static final int EMF223_VALUE = 21;

  /**
   * The '<em><b>EMF224</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.24
   * <!-- end-model-doc -->
   * @see #EMF224
   * @model literal="2.24"
   * @generated
   * @ordered
   */
  public static final int EMF224_VALUE = 22;

  /**
   * The '<em><b>EMF225</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.25
   * <!-- end-model-doc -->
   * @see #EMF225
   * @model literal="2.25"
   * @generated
   * @ordered
   */
  public static final int EMF225_VALUE = 23;

  /**
   * The '<em><b>EMF226</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.26
   * <!-- end-model-doc -->
   * @see #EMF226
   * @model literal="2.26"
   * @generated
   * @ordered
   */
  public static final int EMF226_VALUE = 24;

  /**
   * The '<em><b>EMF227</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.27
   * <!-- end-model-doc -->
   * @see #EMF227
   * @model literal="2.27"
   * @generated
   * @ordered
   */
  public static final int EMF227_VALUE = 25;

  /**
   * The '<em><b>EMF228</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.28
   * <!-- end-model-doc -->
   * @see #EMF228
   * @model literal="2.28"
   * @generated
   * @ordered
   */
  public static final int EMF228_VALUE = 26;

  /**
   * The '<em><b>EMF229</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.29
   * <!-- end-model-doc -->
   * @see #EMF229
   * @model literal="2.29"
   * @generated
   * @ordered
   */
  public static final int EMF229_VALUE = 27;

  /**
   * The '<em><b>EMF230</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.30
   * <!-- end-model-doc -->
   * @see #EMF230
   * @model literal="2.30"
   * @generated
   * @ordered
   */
  public static final int EMF230_VALUE = 28;

  /**
   * The '<em><b>EMF231</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.31
   * <!-- end-model-doc -->
   * @see #EMF231
   * @model literal="2.31"
   * @generated
   * @ordered
   */
  public static final int EMF231_VALUE = 29;

  /**
   * The '<em><b>EMF232</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.32
   * <!-- end-model-doc -->
   * @see #EMF232
   * @model literal="2.32"
   * @generated
   * @ordered
   */
  public static final int EMF232_VALUE = 30;

  /**
   * The '<em><b>EMF233</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.33
   * <!-- end-model-doc -->
   * @see #EMF233
   * @model literal="2.33"
   * @generated
   * @ordered
   */
  public static final int EMF233_VALUE = 31;

  /**
   * The '<em><b>EMF234</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.34
   * <!-- end-model-doc -->
   * @see #EMF234
   * @model literal="2.34"
   * @generated
   * @ordered
   */
  public static final int EMF234_VALUE = 32;

  /**
   * The '<em><b>EMF235</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.35
   * <!-- end-model-doc -->
   * @see #EMF235
   * @model literal="2.35"
   * @generated
   * @ordered
   */
  public static final int EMF235_VALUE = 33;

  /**
   * The '<em><b>EMF236</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.36
   * <!-- end-model-doc -->
   * @see #EMF236
   * @model literal="2.36"
   * @generated
   * @ordered
   */
  public static final int EMF236_VALUE = 34;

  /**
   * The '<em><b>EMF237</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.37
   * <!-- end-model-doc -->
   * @see #EMF237
   * @model literal="2.37"
   * @generated
   * @ordered
   */
  public static final int EMF237_VALUE = 35;

  /**
   * The '<em><b>EMF238</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.38
   * <!-- end-model-doc -->
   * @see #EMF238
   * @model literal="2.38"
   * @generated
   * @ordered
   */
  public static final int EMF238_VALUE = 36;

  /**
   * The '<em><b>EMF239</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.39
   * <!-- end-model-doc -->
   * @see #EMF239
   * @model literal="2.39"
   * @generated
   * @ordered
   */
  public static final int EMF239_VALUE = 37;

  /**
   * The '<em><b>EMF240</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * @since 2.40
   * <!-- end-model-doc -->
   * @see #EMF240
   * @model literal="2.40"
   * @generated
   * @ordered
   */
  public static final int EMF240_VALUE = 38;

  /**
   * An array of all the '<em><b>Gen Runtime Version</b></em>' enumerators.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static final GenRuntimeVersion[] VALUES_ARRAY =
    new GenRuntimeVersion[]
    {
      EMF22,
      EMF23,
      EMF24,
      EMF25,
      EMF26,
      EMF27,
      EMF28,
      EMF29,
      EMF210,
      EMF211,
      EMF212,
      EMF213,
      EMF214,
      EMF215,
      EMF216,
      EMF217,
      EMF218,
      EMF219,
      EMF220,
      EMF221,
      EMF222,
      EMF223,
      EMF224,
      EMF225,
      EMF226,
      EMF227,
      EMF228,
      EMF229,
      EMF230,
      EMF231,
      EMF232,
      EMF233,
      EMF234,
      EMF235,
      EMF236,
      EMF237,
      EMF238,
      EMF239,
      EMF240,
    };

  /**
   * A public read-only list of all the '<em><b>Gen Runtime Version</b></em>' enumerators.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final List<GenRuntimeVersion> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

  /**
   * Returns the '<em><b>Gen Runtime Version</b></em>' literal with the specified literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param literal the literal.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static GenRuntimeVersion get(String literal)
  {
    for (int i = 0; i < VALUES_ARRAY.length; ++i)
    {
      GenRuntimeVersion result = VALUES_ARRAY[i];
      if (result.toString().equals(literal))
      {
        return result;
      }
    }
    return null;
  }

  /**
   * Returns the '<em><b>Gen Runtime Version</b></em>' literal with the specified name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param name the name.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static GenRuntimeVersion getByName(String name)
  {
    for (int i = 0; i < VALUES_ARRAY.length; ++i)
    {
      GenRuntimeVersion result = VALUES_ARRAY[i];
      if (result.getName().equals(name))
      {
        return result;
      }
    }
    return null;
  }

  /**
   * Returns the '<em><b>Gen Runtime Version</b></em>' literal with the specified integer value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the integer value.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static GenRuntimeVersion get(int value)
  {
    switch (value)
    {
      case EMF22_VALUE: return EMF22;
      case EMF23_VALUE: return EMF23;
      case EMF24_VALUE: return EMF24;
      case EMF25_VALUE: return EMF25;
      case EMF26_VALUE: return EMF26;
      case EMF27_VALUE: return EMF27;
      case EMF28_VALUE: return EMF28;
      case EMF29_VALUE: return EMF29;
      case EMF210_VALUE: return EMF210;
      case EMF211_VALUE: return EMF211;
      case EMF212_VALUE: return EMF212;
      case EMF213_VALUE: return EMF213;
      case EMF214_VALUE: return EMF214;
      case EMF215_VALUE: return EMF215;
      case EMF216_VALUE: return EMF216;
      case EMF217_VALUE: return EMF217;
      case EMF218_VALUE: return EMF218;
      case EMF219_VALUE: return EMF219;
      case EMF220_VALUE: return EMF220;
      case EMF221_VALUE: return EMF221;
      case EMF222_VALUE: return EMF222;
      case EMF223_VALUE: return EMF223;
      case EMF224_VALUE: return EMF224;
      case EMF225_VALUE: return EMF225;
      case EMF226_VALUE: return EMF226;
      case EMF227_VALUE: return EMF227;
      case EMF228_VALUE: return EMF228;
      case EMF229_VALUE: return EMF229;
      case EMF230_VALUE: return EMF230;
      case EMF231_VALUE: return EMF231;
      case EMF232_VALUE: return EMF232;
      case EMF233_VALUE: return EMF233;
      case EMF234_VALUE: return EMF234;
      case EMF235_VALUE: return EMF235;
      case EMF236_VALUE: return EMF236;
      case EMF237_VALUE: return EMF237;
      case EMF238_VALUE: return EMF238;
      case EMF239_VALUE: return EMF239;
      case EMF240_VALUE: return EMF240;
    }
    return null;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final int value;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final String name;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final String literal;

  /**
   * Only this class can construct instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private GenRuntimeVersion(int value, String name, String literal)
  {
    this.value = value;
    this.name = name;
    this.literal = literal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public int getValue()
  {
    return value;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String getName()
  {
    return name;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String getLiteral()
  {
    return literal;
  }

  /**
   * Returns the literal value of the enumerator, which is its string representation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String toString()
  {
    return literal;
  }

} //GenRuntimeVersion
