/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.WindowEvent;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.text.hover.HtmlString;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistContextData;
import org.eclipse.fx.text.ui.contentassist.ContentAssistant;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.text.ui.contentassist.IContentAssistListener;
import org.eclipse.fx.text.ui.contentassist.LazyInitReference;
import org.eclipse.fx.text.ui.hover.internal.ResizeablePopupWindow;
import org.eclipse.fx.text.ui.internal.SimpleHtmlViewer;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;

public class ContentProposalPopup
implements IContentAssistListener {
    ITextViewer viewer;
    private LazyInitReference<ResizeablePopupWindow> stage = new LazyInitReference();
    private ListView<ICompletionProposal> proposalList;
    private SimpleHtmlViewer htmlViewer;
    private String prefix;
    int offset;
    private Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer;
    private ContentAssistant fContentAssistant;
    private ChangeListener<Number> selectionChange;
    private ICompletionProposal chosenProposal = null;
    private final ThreadSynchronize threadSync;
    private final EventHandler<MouseEvent> mouseEvent;
    private CompletableFuture<Optional<ICompletionProposal>> future;

    public void configureWindowSize(Supplier<Point2D> windowSizeRetriever, Consumer<Point2D> windowSizePersister) {
        this.stage.init(stage -> stage.configureWindowSize(windowSizeRetriever, windowSizePersister));
    }

    public ContentProposalPopup(ThreadSynchronize threadSync, ContentAssistant assistant, ITextViewer viewer, Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer) {
        this.threadSync = threadSync;
        this.viewer = viewer;
        this.proposalComputer = proposalComputer;
        this.fContentAssistant = assistant;
        this.selectionChange = this::onSelectionChange;
        this.mouseEvent = this::onMouseEvent;
    }

    public CompletableFuture<Optional<ICompletionProposal>> displayProposals(List<ICompletionProposal> proposalList, int offset, Point2D position) {
        this.setup();
        if (this.stage.get().isShowing()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        this.future = new CompletableFuture();
        this.prefix = "";
        this.offset = offset;
        this.proposalList.setItems(FXCollections.observableArrayList(proposalList));
        this.proposalList.getSelectionModel().select(0);
        this.stage.get().setX(position.getX());
        this.stage.get().setY(position.getY());
        this.stage.get().requestFocus();
        this.stage.get().show(this.viewer.getTextWidget().getScene().getWindow(), position.getX(), position.getY(), this.viewer.getTextWidget().getFixedLineHeight());
        this.proposalList.requestFocus();
        this.chosenProposal = null;
        return this.future;
    }

    public void close() {
        this.stage.get().hide();
    }

    private void subscribe(Event e) {
        this.viewer.getTextWidget().caretOffsetProperty().addListener(this.selectionChange);
        this.viewer.getTextWidget().getScene().addEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseEvent);
    }

    private void unsubscribe(Event e) {
        this.viewer.getTextWidget().caretOffsetProperty().removeListener(this.selectionChange);
        this.viewer.getTextWidget().getScene().removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseEvent);
    }

    private void onMouseEvent(MouseEvent e) {
        this.close();
    }

    private void onSelectionChange(Observable x, Number oldSelection, Number newSelection) {
        this.offset = this.viewer.getTextWidget().getCaretOffset();
        this.updateProposals();
    }

    private void updateProposals() {
        List<ICompletionProposal> list = this.proposalComputer.apply(new ContentAssistContextData(this.offset, this.viewer.getDocument()));
        if (!list.isEmpty()) {
            this.proposalList.setItems(FXCollections.observableArrayList(list));
            this.proposalList.scrollTo(0);
            this.proposalList.getSelectionModel().select(0);
            this.proposalList.requestFocus();
        } else {
            this.stage.get().hide();
        }
    }

    private void cancelProposal() {
        this.chosenProposal = null;
        this.close();
    }

    private void applySelectedProposal() {
        ICompletionProposal selectedItem;
        this.chosenProposal = selectedItem = (ICompletionProposal)this.proposalList.getSelectionModel().getSelectedItem();
        this.close();
    }

    private void handleMouseClicked(MouseEvent event) {
        if (event.isStillSincePress() && event.getClickCount() == 2) {
            this.applySelectedProposal();
        }
    }

    private void handleKeyPressed(KeyEvent event) {
        switch (event.getCode()) {
            case ESCAPE: {
                event.consume();
                this.cancelProposal();
                break;
            }
            case ENTER: {
                event.consume();
                this.applySelectedProposal();
                break;
            }
            case LEFT: {
                event.consume();
                this.viewer.getTextWidget().setCaretOffset(Math.max(0, this.viewer.getTextWidget().getCaretOffset() - 1));
                break;
            }
            case RIGHT: {
                event.consume();
                this.viewer.getTextWidget().setCaretOffset(Math.min(this.viewer.getDocument().getLength() - 1, this.viewer.getTextWidget().getCaretOffset() + 1));
                break;
            }
        }
    }

    private static HtmlString getHtml(ICompletionProposal proposal) {
        if (proposal != null && proposal.getHoverInfo() != null) {
            if (proposal.getHoverInfo() instanceof HtmlString) {
                return (HtmlString)proposal.getHoverInfo();
            }
            if (proposal.getHoverInfo().toString().startsWith("<html>")) {
                return new HtmlString(proposal.getHoverInfo().toString());
            }
            return new HtmlString("<html><body><pre>" + proposal.getHoverInfo() + "</pre></body></html>");
        }
        return new HtmlString("<html></html>");
    }

    private void setup() {
        if (!this.stage.isInitialized()) {
            this.htmlViewer = new SimpleHtmlViewer();
            this.htmlViewer.setPrefWidth(300.0);
            StackPane docArea = new StackPane();
            docArea.getStyleClass().add((Object)"content-proposal-doc");
            docArea.getChildren().add((Object)this.htmlViewer);
            this.stage.setFactory(() -> {
                BorderPane p = new BorderPane();
                p.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
                ResizeablePopupWindow s = new ResizeablePopupWindow((Node)p);
                s.setAutoFix(false);
                s.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyPressed);
                p.getStyleClass().add((Object)"content-proposal-container");
                s.focusedProperty().addListener(o -> {
                    if (this.stage != null && !s.isFocused()) {
                        Platform.runLater(() -> ((ResizeablePopupWindow)s).hide());
                    }
                });
                s.setOnShowing(this::subscribe);
                s.addEventHandler(WindowEvent.WINDOW_HIDDEN, this::unsubscribe);
                s.showingProperty().addListener((x, o, n) -> {
                    if (!n.booleanValue()) {
                        this.future.complete(Optional.ofNullable(this.chosenProposal));
                        this.stage.clean();
                    }
                });
                SplitPane splitty = new SplitPane(new Node[]{this.proposalList, docArea});
                splitty.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
                SplitPane.setResizableWithParent(this.proposalList, (Boolean)Boolean.FALSE);
                p.setCenter((Node)splitty);
                splitty.prefWidthProperty().bind((ObservableValue)p.widthProperty());
                return s;
            });
            this.proposalList = new ListView();
            this.proposalList.setMinWidth(300.0);
            this.proposalList.getStyleClass().add((Object)"content-proposal-list");
            this.proposalList.setOnMouseClicked(this::handleMouseClicked);
            this.proposalList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.htmlViewer.setContent(ContentProposalPopup.getHtml(newValue)));
            this.proposalList.setCellFactory(CompletionCell::new);
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent event) {
        return true;
    }

    static class CompletionCell
    extends ListCell<ICompletionProposal> {
        public CompletionCell(ListView<ICompletionProposal> v) {
        }

        protected void updateItem(ICompletionProposal item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null && !empty) {
                HBox box = new HBox();
                box.setAlignment(Pos.CENTER_LEFT);
                Node graphic = item.getGraphic();
                Node content = item.getContentNode();
                if (graphic != null) {
                    box.getChildren().add((Object)graphic);
                }
                box.getChildren().add((Object)content);
                HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
                this.setGraphic((Node)box);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

