/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(service={ExtendedObjectSupplier.class, EventHandler.class}, property={"dependency.injection.annotation=org.eclipse.e4.core.di.extensions.Preference", "event.topics=org/eclipse/e4/core/contexts/IEclipseContext/DISPOSE"}, immediate=true)
public class PreferencesObjectSupplier
extends ExtendedObjectSupplier
implements EventHandler {
    private IPreferencesService preferencesService;
    private Map<String, HashMap<String, List<PrefInjectionListener>>> listenerCache = new HashMap<String, HashMap<String, List<PrefInjectionListener>>>();

    public IPreferencesService getPreferencesService() {
        return this.preferencesService;
    }

    @Reference
    public void setPreferencesService(IPreferencesService preferenceService) {
        this.preferencesService = preferenceService;
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        if (descriptor == null) {
            return null;
        }
        Class<?> descriptorsClass = this.getDesiredClass(descriptor.getDesiredType());
        String nodePath = this.getNodePath(descriptor, requestor.getRequestingObjectClass());
        if (IEclipsePreferences.class.equals(descriptorsClass)) {
            return InstanceScope.INSTANCE.getNode(nodePath);
        }
        String key = this.getKey(descriptor);
        if (key == null || nodePath == null || key.isEmpty() || nodePath.isEmpty()) {
            return IInjector.NOT_A_VALUE;
        }
        if (track) {
            this.addListener(nodePath, key, requestor);
        }
        if (descriptorsClass.isPrimitive()) {
            if (descriptorsClass.equals(Boolean.TYPE)) {
                return this.getPreferencesService().getBoolean(nodePath, key, false, null);
            }
            if (descriptorsClass.equals(Integer.TYPE)) {
                return this.getPreferencesService().getInt(nodePath, key, 0, null);
            }
            if (descriptorsClass.equals(Double.TYPE)) {
                return this.getPreferencesService().getDouble(nodePath, key, 0.0, null);
            }
            if (descriptorsClass.equals(Float.TYPE)) {
                return Float.valueOf(this.getPreferencesService().getFloat(nodePath, key, 0.0f, null));
            }
            if (descriptorsClass.equals(Long.TYPE)) {
                return this.getPreferencesService().getLong(nodePath, key, 0L, null);
            }
        }
        if (String.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getString(nodePath, key, null, null);
        }
        if (Boolean.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getBoolean(nodePath, key, false, null);
        }
        if (Integer.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getInt(nodePath, key, 0, null);
        }
        if (Double.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getDouble(nodePath, key, 0.0, null);
        }
        if (Float.class.equals(descriptorsClass)) {
            return Float.valueOf(this.getPreferencesService().getFloat(nodePath, key, 0.0f, null));
        }
        if (Long.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getLong(nodePath, key, 0L, null);
        }
        return this.getPreferencesService().getString(nodePath, key, null, null);
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        return qualifier.value();
    }

    private String getNodePath(IObjectDescriptor descriptor, Class<?> requestingObject) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        String nodePath = qualifier.nodePath();
        if (nodePath == null || nodePath.isEmpty()) {
            if (requestingObject == null) {
                return null;
            }
            nodePath = FrameworkUtil.getBundle(requestingObject).getSymbolicName();
        }
        return nodePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String nodePath, String key, IRequestor requestor) {
        if (requestor == null) {
            return;
        }
        Map<String, HashMap<String, List<PrefInjectionListener>>> map = this.listenerCache;
        synchronized (map) {
            HashMap<String, List<PrefInjectionListener>> map2;
            if (this.listenerCache.containsKey(nodePath) && (map2 = this.listenerCache.get(nodePath)).containsKey(key)) {
                for (PrefInjectionListener listener : map2.get(key)) {
                    IRequestor previousRequestor = listener.getRequestor();
                    if (!previousRequestor.equals(requestor)) continue;
                    return;
                }
            }
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        PrefInjectionListener listener = new PrefInjectionListener(node, key, requestor);
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
        Map<String, HashMap<String, List<PrefInjectionListener>>> map3 = this.listenerCache;
        synchronized (map3) {
            List<PrefInjectionListener> listeningRequestors;
            HashMap<String, List<PrefInjectionListener>> map4 = this.listenerCache.get(nodePath);
            if (map4 == null) {
                map4 = new HashMap();
                this.listenerCache.put(nodePath, map4);
            }
            if ((listeningRequestors = map4.get(key)) == null) {
                listeningRequestors = new ArrayList<PrefInjectionListener>();
                map4.put(key, listeningRequestors);
            }
            listeningRequestors.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void removeAllListeners() {
        Map<String, HashMap<String, List<PrefInjectionListener>>> map = this.listenerCache;
        synchronized (map) {
            for (HashMap<String, List<PrefInjectionListener>> map2 : this.listenerCache.values()) {
                for (List<PrefInjectionListener> listeners : map2.values()) {
                    if (listeners == null) continue;
                    for (PrefInjectionListener listener : listeners) {
                        listener.stopListening();
                    }
                }
            }
            this.listenerCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        Map<String, HashMap<String, List<PrefInjectionListener>>> map = this.listenerCache;
        synchronized (map) {
            Iterator<Map.Entry<String, HashMap<String, List<PrefInjectionListener>>>> nodesIterator = this.listenerCache.entrySet().iterator();
            while (nodesIterator.hasNext()) {
                HashMap<String, List<PrefInjectionListener>> map2 = nodesIterator.next().getValue();
                Iterator<Map.Entry<String, List<PrefInjectionListener>>> valuesIterator = map2.entrySet().iterator();
                while (valuesIterator.hasNext()) {
                    List<PrefInjectionListener> listeners = valuesIterator.next().getValue();
                    if (listeners == null) continue;
                    Iterator<PrefInjectionListener> listenerIterator = listeners.iterator();
                    while (listenerIterator.hasNext()) {
                        PrefInjectionListener listener = listenerIterator.next();
                        if (listener.getRequestor().isValid()) continue;
                        listener.stopListening();
                        listenerIterator.remove();
                    }
                    if (!listeners.isEmpty()) continue;
                    valuesIterator.remove();
                }
                if (!map2.isEmpty()) continue;
                nodesIterator.remove();
            }
        }
    }

    private static class PrefInjectionListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IRequestor requestor;
        private final IEclipsePreferences node;
        private final String key;

        public PrefInjectionListener(IEclipsePreferences node, String key, IRequestor requestor) {
            this.node = node;
            this.key = key;
            this.requestor = requestor;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!this.requestor.isValid()) {
                this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                return;
            }
            if (!event.getKey().equals(this.key)) {
                return;
            }
            this.requestor.resolveArguments(false);
            this.requestor.execute();
        }

        public IRequestor getRequestor() {
            return this.requestor;
        }

        public void stopListening() {
            this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }
}

