/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.groups.observer;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IProcess;

public final class ProcessObserver
implements Callable<Integer> {
    private final IProcess p;
    private final IProgressMonitor pMonitor;
    private final CountDownLatch countDownLatch;

    public ProcessObserver(IProgressMonitor monitor, IProcess p, CountDownLatch countDownLatch) {
        this.p = p;
        this.pMonitor = monitor;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public Integer call() throws Exception {
        try {
            while (!this.p.isTerminated() && !this.pMonitor.isCanceled()) {
                TimeUnit.MILLISECONDS.sleep(250L);
                if (this.countDownLatch.getCount() == 0L) break;
            }
            if (this.p.isTerminated()) {
                Integer n = this.p.getExitValue();
                return n;
            }
            Integer n = 0;
            return n;
        }
        finally {
            this.countDownLatch.countDown();
        }
    }
}

