/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-audit-module")
@PerLookup
@I18n(value="delete.audit.module")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteAuditModule
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteAuditModule.class);
    @Param(name="auditmodulename", primary=true)
    String auditModuleName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @AccessRequired.To(value={"delete"})
    private AuditModule auditModule = null;
    @Inject
    SecurityConfigListener securityConfigListener;
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.auditModule = this.chooseAuditModule(context.getActionReport());
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.auditModule == null) {
                report.setMessage(localStrings.getLocalString("delete.audit.module.notfound", "Specified Audit Module {0} not found", new Object[]{this.auditModuleName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    param.getAuditModule().remove(DeleteAuditModule.this.auditModule);
                    return null;
                }
            }, (ConfigBeanProxy)this.securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.audit.module.fail", "Deletion of Audit Module {0} failed", new Object[]{this.auditModuleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private AuditModule chooseAuditModule(ActionReport report) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, report);
        if (this.config == null) {
            return null;
        }
        this.securityService = this.config.getSecurityService();
        for (AuditModule am : this.securityService.getAuditModule()) {
            if (!am.getName().equals(this.auditModuleName)) continue;
            return am;
        }
        return null;
    }
}

