/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.converter.DateConverter;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.validator.DateInRangeValidator;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;

public class Calendar
extends Field
implements DateManager,
NamingContainer {
    private static final String DATE_PICKER_LINK_FACET = "datePickerLink";
    private static final String DATE_PICKER_LINK_ID = "_datePickerLink";
    private static final String DATE_PICKER_FACET = "datePicker";
    private static final String DATE_PICKER_ID = "_datePicker";
    public static final String PATTERN_ID = "_pattern";
    private DateConverter dateConverter = null;
    private String dateFormatPattern = null;
    private String dateFormatPatternHelp = null;
    private Date maxDate = null;
    private Date minDate = null;
    private TimeZone timeZone = null;

    public Calendar() {
        this.setRendererType("com.sun.webui.jsf.Calendar");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Calendar";
    }

    public ImageHyperlink getDatePickerLink(FacesContext context) {
        ImageHyperlink datePickerLink;
        UIComponent component = this.getFacet(DATE_PICKER_LINK_FACET);
        if (component instanceof ImageHyperlink) {
            datePickerLink = (ImageHyperlink)component;
        } else {
            datePickerLink = new ImageHyperlink();
            this.getFacets().put(DATE_PICKER_LINK_FACET, datePickerLink);
        }
        datePickerLink.setId(DATE_PICKER_LINK_ID);
        datePickerLink.setAlign("middle");
        StringBuffer js = new StringBuffer(200);
        js.append("javascript: ").append(this.getJavaScriptObjectName(context)).append(".toggle(); return false;");
        datePickerLink.setOnClick(js.toString());
        return datePickerLink;
    }

    public CalendarMonth getDatePicker() {
        Object comp = this.getFacet(DATE_PICKER_FACET);
        if (comp == null || !(comp instanceof CalendarMonth)) {
            CalendarMonth datePicker = new CalendarMonth();
            datePicker.setPopup(true);
            datePicker.setId(DATE_PICKER_ID);
            this.getFacets().put(DATE_PICKER_FACET, datePicker);
            comp = datePicker;
        }
        ((CalendarMonth)((Object)comp)).setJavaScriptObjectName(this.getJavaScriptObjectName(FacesContext.getCurrentInstance()));
        return (CalendarMonth)((Object)comp);
    }

    public String getJavaScriptObjectName(FacesContext context) {
        return JavaScriptUtilities.getDomNode(this.getFacesContext(), (UIComponent)this);
    }

    public Converter getConverter() {
        Converter converter;
        Validator[] validators = this.getValidators();
        int len = validators.length;
        boolean found = false;
        for (int i = 0; i < len; ++i) {
            if (!(validators[i] instanceof DateInRangeValidator)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addValidator(new DateInRangeValidator());
        }
        if ((converter = super.getConverter()) == null) {
            if (this.dateConverter == null) {
                this.dateConverter = new DateConverter();
            }
            converter = this.dateConverter;
        }
        return converter;
    }

    public String getReadOnlyValueString(FacesContext context) {
        if (this.getValue() == null) {
            return "-";
        }
        return super.getReadOnlyValueString(context);
    }

    public DateFormat getDateFormat() {
        return this.getDatePicker().getDateFormat();
    }

    public Date getFirstAvailableDate() {
        Date minDate = this.getMinDate();
        if (minDate == null) {
            java.util.Calendar calendar = this.getDatePicker().getCalendar();
            calendar.add(1, -100);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            minDate = calendar.getTime();
        }
        return minDate;
    }

    public Date getLastAvailableDate() {
        Date maxDate = this.getMaxDate();
        if (maxDate == null) {
            Date minDate = this.getFirstAvailableDate();
            java.util.Calendar calendar = this.getDatePicker().getCalendar();
            calendar.setTime(minDate);
            calendar.add(1, 200);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            maxDate = calendar.getTime();
        }
        return maxDate;
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public String getLabeledElementId(FacesContext context) {
        return this.getClientId(context).concat("_field");
    }

    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this._setDateFormatPattern(dateFormatPattern);
        CalendarMonth dp = this.getDatePicker();
        dp.setDateFormatPattern(dateFormatPattern);
    }

    public void setTimeZone(TimeZone timeZone) {
        this._setTimeZone(timeZone);
        CalendarMonth dp = this.getDatePicker();
        dp.setTimeZone(timeZone);
    }

    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public int getMaxLength() {
        return super.getMaxLength();
    }

    public Object getText() {
        return super.getText();
    }

    public boolean isTrim() {
        return super.isTrim();
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("selectedDate")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("selectedDate")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public String getDateFormatPattern() {
        if (this.dateFormatPattern != null) {
            return this.dateFormatPattern;
        }
        ValueExpression _vb = this.getValueExpression("dateFormatPattern");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void _setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public String getDateFormatPatternHelp() {
        if (this.dateFormatPatternHelp != null) {
            return this.dateFormatPatternHelp;
        }
        ValueExpression _vb = this.getValueExpression("dateFormatPatternHelp");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateFormatPatternHelp(String dateFormatPatternHelp) {
        this.dateFormatPatternHelp = dateFormatPatternHelp;
    }

    public Date getMaxDate() {
        if (this.maxDate != null) {
            return this.maxDate;
        }
        ValueExpression _vb = this.getValueExpression("maxDate");
        if (_vb != null) {
            return (Date)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Date getMinDate() {
        if (this.minDate != null) {
            return this.minDate;
        }
        ValueExpression _vb = this.getValueExpression("minDate");
        if (_vb != null) {
            return (Date)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Date getSelectedDate() {
        return (Date)this.getValue();
    }

    public void setSelectedDate(Date selectedDate) {
        this.setValue(selectedDate);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        ValueExpression _vb = this.getValueExpression("timeZone");
        if (_vb != null) {
            return (TimeZone)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private void _setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.dateFormatPattern = (String)_values[1];
        this.dateFormatPatternHelp = (String)_values[2];
        this.maxDate = (Date)_values[3];
        this.minDate = (Date)_values[4];
        this.timeZone = (TimeZone)_values[5];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.dateFormatPattern, this.dateFormatPatternHelp, this.maxDate, this.minDate, this.timeZone};
        return _values;
    }
}

